/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.zuul.context;

import com.nepxion.discovery.plugin.strategy.context.AbstractStrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.zuul.context.ZuulStrategyContext;
import com.netflix.zuul.context.RequestContext;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ZuulStrategyContextHolder
extends AbstractStrategyContextHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ZuulStrategyContextHolder.class);
    @Value(value="${spring.application.strategy.zuul.header.priority:true}")
    protected Boolean zuulHeaderPriority;
    @Value(value="${spring.application.strategy.zuul.original.header.ignored:true}")
    protected Boolean zuulOriginalHeaderIgnored;

    public HttpServletRequest getRequest() {
        HttpServletRequest request = ZuulStrategyContext.getCurrentContext().getRequest();
        if (request == null) {
            request = RequestContext.getCurrentContext().getRequest();
        }
        return request;
    }

    public Map<String, String> getZuulRequestHeaders() {
        Map headers = ZuulStrategyContext.getCurrentContext().getHeaders();
        if (headers == null) {
            headers = RequestContext.getCurrentContext().getZuulRequestHeaders();
        }
        return headers;
    }

    public String getHeader(String name) {
        HttpServletRequest request = this.getRequest();
        if (request == null) {
            LOG.warn("The HttpServletRequest object is lost for thread switched, or it is got before context filter probably");
            return null;
        }
        if (this.zuulHeaderPriority.booleanValue()) {
            String header = this.getZuulRequestHeaders().get(name);
            if (StringUtils.isEmpty((CharSequence)header)) {
                header = this.isRouteValue(name) && this.zuulOriginalHeaderIgnored != false ? null : request.getHeader(name);
            }
            return header;
        }
        String header = request.getHeader(name);
        if (StringUtils.isEmpty((CharSequence)header)) {
            header = this.getZuulRequestHeaders().get(name);
        }
        return header;
    }

    private boolean isRouteValue(String name) {
        return StringUtils.equals((CharSequence)name, (CharSequence)"n-d-version") || StringUtils.equals((CharSequence)name, (CharSequence)"n-d-region") || StringUtils.equals((CharSequence)name, (CharSequence)"n-d-address") || StringUtils.equals((CharSequence)name, (CharSequence)"n-d-version-weight") || StringUtils.equals((CharSequence)name, (CharSequence)"n-d-region-weight");
    }
}

