/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.zuul.filter;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.StrategyCustomizationEntity;
import com.nepxion.discovery.common.entity.StrategyHeaderEntity;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.zuul.filter.ZuulStrategyFilterResolver;
import com.nepxion.discovery.plugin.strategy.zuul.filter.ZuulStrategyRouteFilter;
import com.nepxion.discovery.plugin.strategy.zuul.monitor.ZuulStrategyMonitor;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractZuulStrategyRouteFilter
extends ZuulFilter
implements ZuulStrategyRouteFilter {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Autowired(required=false)
    private ZuulStrategyMonitor zuulStrategyMonitor;
    @Value(value="${spring.application.strategy.zuul.header.priority:true}")
    protected Boolean zuulHeaderPriority;
    @Value(value="${spring.application.strategy.zuul.original.header.ignored:true}")
    protected Boolean zuulOriginalHeaderIgnored;
    @Value(value="${spring.application.strategy.zuul.route.filter.order:0}")
    protected Integer filterOrder;

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return this.filterOrder;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        String path;
        StrategyHeaderEntity strategyHeaderEntity;
        StrategyCustomizationEntity strategyCustomizationEntity;
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity != null && (strategyCustomizationEntity = ruleEntity.getStrategyCustomizationEntity()) != null && (strategyHeaderEntity = strategyCustomizationEntity.getStrategyHeaderEntity()) != null) {
            Map headerMap = strategyHeaderEntity.getHeaderMap();
            for (Map.Entry entry : headerMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                ZuulStrategyFilterResolver.setHeader(key, value, this.zuulHeaderPriority);
            }
        }
        String routeVersion = this.getRouteVersion();
        String routeRegion = this.getRouteRegion();
        String routeAddress = this.getRouteAddress();
        String routeVersionWeight = this.getRouteVersionWeight();
        String routeRegionWeight = this.getRouteRegionWeight();
        if (StringUtils.isNotEmpty((CharSequence)routeVersion)) {
            ZuulStrategyFilterResolver.setHeader("n-d-version", routeVersion, this.zuulHeaderPriority);
        } else {
            ZuulStrategyFilterResolver.ignoreHeader("n-d-version", this.zuulHeaderPriority, this.zuulOriginalHeaderIgnored);
        }
        if (StringUtils.isNotEmpty((CharSequence)routeRegion)) {
            ZuulStrategyFilterResolver.setHeader("n-d-region", routeRegion, this.zuulHeaderPriority);
        } else {
            ZuulStrategyFilterResolver.ignoreHeader("n-d-region", this.zuulHeaderPriority, this.zuulOriginalHeaderIgnored);
        }
        if (StringUtils.isNotEmpty((CharSequence)routeAddress)) {
            ZuulStrategyFilterResolver.setHeader("n-d-address", routeAddress, this.zuulHeaderPriority);
        } else {
            ZuulStrategyFilterResolver.ignoreHeader("n-d-address", this.zuulHeaderPriority, this.zuulOriginalHeaderIgnored);
        }
        if (StringUtils.isNotEmpty((CharSequence)routeVersionWeight)) {
            ZuulStrategyFilterResolver.setHeader("n-d-version-weight", routeVersionWeight, this.zuulHeaderPriority);
        } else {
            ZuulStrategyFilterResolver.ignoreHeader("n-d-version-weight", this.zuulHeaderPriority, this.zuulOriginalHeaderIgnored);
        }
        if (StringUtils.isNotEmpty((CharSequence)routeRegionWeight)) {
            ZuulStrategyFilterResolver.setHeader("n-d-region-weight", routeRegionWeight, this.zuulHeaderPriority);
        } else {
            ZuulStrategyFilterResolver.ignoreHeader("n-d-region-weight", this.zuulHeaderPriority, this.zuulOriginalHeaderIgnored);
        }
        ZuulStrategyFilterResolver.setHeader("n-d-service-group", this.pluginAdapter.getGroup(), this.zuulHeaderPriority);
        ZuulStrategyFilterResolver.setHeader("n-d-service-type", this.pluginAdapter.getServiceType(), false);
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            ZuulStrategyFilterResolver.setHeader("n-d-service-app-id", serviceAppId, false);
        }
        ZuulStrategyFilterResolver.setHeader("n-d-service-id", this.pluginAdapter.getServiceId(), false);
        ZuulStrategyFilterResolver.setHeader("n-d-service-address", this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort(), false);
        ZuulStrategyFilterResolver.setHeader("n-d-service-version", this.pluginAdapter.getVersion(), false);
        ZuulStrategyFilterResolver.setHeader("n-d-service-region", this.pluginAdapter.getRegion(), false);
        ZuulStrategyFilterResolver.setHeader("n-d-service-env", this.pluginAdapter.getEnvironment(), false);
        this.extendFilter();
        RequestContext context = RequestContext.getCurrentContext();
        if (this.zuulStrategyMonitor != null) {
            this.zuulStrategyMonitor.monitor(context);
        }
        if ((path = context.getRequest().getServletPath()).contains("/inspector/inspect")) {
            ZuulStrategyFilterResolver.setHeader("endpoint-inspector-inspect", this.pluginAdapter.getPluginInfo(null), true);
        }
        return null;
    }

    protected void extendFilter() {
    }

    public PluginAdapter getPluginAdapter() {
        return this.pluginAdapter;
    }

    public StrategyContextHolder getStrategyContextHolder() {
        return this.strategyContextHolder;
    }
}

