package com.bxm.foundation.base.facade.bo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/6/16 10:41 上午
 */
@Data
public class EquipmentBO implements Serializable {
    /**
     * 安卓设备标识
     */
    @ApiModelProperty("android:表示唯一值，不同手机返回不同（ IOS_DEVICE_ID/MAC 等 ），本文档中主要用于表示设备唯一码。重置系统不会重置，需要申请权限后获取。")
    private String imei;

    @ApiModelProperty(value = "android imei MD5加密结果", hidden = true)
    private String imeiMd5;

    @ApiModelProperty("android：安卓系统初始化时创建一次，重置系统会被重置")
    private String androidId;

    @ApiModelProperty(value = "android id MD5加密结果", hidden = true)
    private String androidIdMd5;

    @ApiModelProperty("oaid：匿名设备标识符")
    private String oaid;

    @ApiModelProperty("oaidMd5:匿名设备表示符Md5")
    private String oaidMd5;

    @ApiModelProperty("mac:mac地址")
    private String mac;

    @ApiModelProperty("macMd5:mac地址MD5")
    private String macMd5;

    /**
     * IOS标识
     **/
    @ApiModelProperty("ios:广告追踪ID")
    private String idfa;

    @ApiModelProperty(value = "ios:idfa MD5加密结果", hidden = true)
    private String idfaMd5;

    @ApiModelProperty("ios:ios设备ID")
    private String iosId;

    @ApiModelProperty("iosMd5:ios设备ID MD5加密结果")
    private String iosIdMd5;

    @ApiModelProperty(
            value = "基础参数：平台类型,1:ANDROID,2:IOS",
            required = true
    )
    private Integer platform;
}