package com.bxm.foundation.base.facade.enums;

/**
 * 域名场景值枚举
 *
 * @author liujia
 * @date 6/15/21 8:25 PM
 **/
public enum DomainSceneEnum {
    /**
     * 不同的域名应用场景
     */
    INNER_H5("站内h5"),

    AUTH_TAOBAO("淘宝授权"),

    SHORT("短链"),

    OUTSIDE_SHARE("站外分享"),

    OUTSIDE_SHARE_VIEW("站外落地页"),

    WECHAT_AUTH("站外微信用户授权中间页"),

    WECHAT_PAY("站外微信支付中间页"),

    SERVER_HOST("服务器域名"),

    MANAGE_HOST("运营后台域名"),

    THIRD_PARTY_HOST("服务端第三方对接域名"),

    WECHAT_SHORT("微信二次分享短链"),
    ;

    /**
     * 描述
     */
    private String desc;

    DomainSceneEnum(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }
}
