package com.bxm.foundation.base.facade.bo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;

/**
 * @author lowi
 * @date 2021/10/12 10:34
 */
@Data
@ApiModel(description = "app版本更新信息")
@Builder
public class AppChannelVersionBO implements Serializable {

    @Tolerate
    public AppChannelVersionBO() {
    }

    @ApiModelProperty("版本号 1.0.0")
    private String version;

    @ApiModelProperty("更新标题")
    private String title;

    @ApiModelProperty("更新内容")
    private String content;

    @ApiModelProperty("下载地址")
    private String downloadLink;

    @ApiModelProperty(value = "是否强制更新 0.选择更新， 1.强制更新，2.静默更新，3.不用更新")
    private Byte isForce;

    @ApiModelProperty(value = "是否提包状态 1 是 0否")
    private Integer status;
}
