package com.bxm.foundation.base.facade.bo;

import lombok.Data;

/**
 * 落地页base url信息
 *
 * @author gonzo
 * @date 2020-07-30 16:22
 **/
@Data
public class ViewSceneBaseUrl {

    /**
     * 域名
     */
    private String domain;

    /**
     * 包含了domain以及部分跟路径的url
     * 根路径的拼接，是约定好按照场景进行的拼接
     * /结尾
     */
    private String baseUrl;

    /**
     * @see com.bxm.localnews.common.constant.DomainScene.DomainViewScene
     * 落地页场景类型
     */
    private String viewScene;

    /**
     * 落地页域名(如 WX_JS_VIEW)对应的appId
     */
    private String appId;
}
