package com.bxm.foundation.base.facade.enums;

import java.util.Objects;

/**
 * 域名类型划分的枚举
 *
 * @author gonzo
 * @date 2020-07-30 17:02
 **/
public enum DomainScene {
    /**
     * 域名类型划分的枚举
     */
    INNER_H5((byte) 0, "站内h5"),
    AUTH_TAOBAO((byte) 1, "淘宝授权"),
    SHORT((byte) 2, "短链"),
    OUTSIDE_SHARE((byte) 3, "站外分享"),
    OUTSIDE_SHARE_VIEW((byte) 4, "站外落地页"),
    WECHAT_AUTH((byte) 5, "站外微信用户授权中间页"),
    WECHAT_PAY((byte) 6, "站外微信支付中间页"),
    SERVER_HOST((byte) 7, "服务器域名"),
    WECHAT_SHORT((byte) 8, "微信二次分享短链"),
    THIRD_PARTY_HOST((byte) 9, "第三方回调网关域名"),
    MANAGE_HOST((byte) 10, "运营后台服务域名"),
    ;

    /**
     * 场景值
     */
    private byte scene;

    /**
     * 描述
     */
    private String desc;

    DomainScene(byte scene, String desc) {
        this.scene = scene;
        this.desc = desc;
    }

    public byte getScene() {
        return scene;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据name 获取对应的枚举
     *
     * @param name name
     * @return 枚举包装optional
     */
    public static DomainScene forName(String name) {
        for (DomainScene value : values()) {
            if (Objects.equals(value.name(), name)) {
                return value;
            }
        }

        return null;
    }

    /**
     * 根据scene 获取对应的枚举
     *
     * @param scene scene
     * @return 枚举包装optional
     */
    public static DomainScene forScene(Byte scene) {
        for (DomainScene value : values()) {
            if (Objects.equals(value.getScene(), scene)) {
                return value;
            }
        }

        return null;
    }

    /**
     * 根据scene 获取对应的枚举
     *
     * @param sceneName scene
     * @return 枚举包装optional
     */
    public static DomainScene getScene(String sceneName) {
        for (DomainScene value : values()) {
            if (Objects.equals(value.name(), sceneName)) {
                return value;
            }
        }
        return null;
    }


}
