package com.bxm.foundation.base.facade.enums;

import java.util.Objects;

/**
 * 分享落地页场景类型
 *
 * @author Gonzo
 * @date 2020-07-31 20:41
 * @since 1.0.0
 */
public enum DomainViewScene {
    /**
     * 场景值
     */
    CONTENT_VIEW((byte) 1, "站外内容落地页"),
    PROMOTION_VIEW((byte) 2, "站外推广落地页"),
    ACTIVITY_VIEW((byte) 3, "站外活动落地页"),
    WX_JS_VIEW((byte) 4, "带微信JS API权限的落地页"),
    ADD_FRIEND((byte) 5, "站外添加好友页"),
    ;


    private byte scene;

    /**
     * 描述
     */
    private String desc;

    DomainViewScene(byte scene, String desc) {
        this.scene = scene;
        this.desc = desc;
    }

    public byte getScene() {
        return scene;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据name 获取对应的枚举
     *
     * @param name name
     * @return 枚举包装optional
     */
    public static DomainViewScene forName(String name) {
        for (DomainViewScene value : values()) {
            if (Objects.equals(value.name(), name)) {
                return value;
            }
        }
        return null;
    }

    /**
     * 根据viewScene 获取对应的枚举
     *
     * @param viewScene viewScene
     * @return 枚举包装optional
     */
    public static DomainViewScene forViewScene(Byte viewScene) {
        for (DomainViewScene value : values()) {
            if (Objects.equals(value.getScene(), viewScene)) {
                return value;
            }
        }
        return null;
    }
}