package com.bxm.foundation.base.facade.service;

import com.bxm.foundation.base.facade.bo.ViewSceneBaseUrl;
import com.bxm.foundation.base.facade.enums.DomainScene;
import com.bxm.foundation.base.facade.enums.DomainViewScene;
import com.bxm.foundation.base.facade.param.DomainFetchParam;

/**
 * 域名内部服务 提供了一些大众场景的base url获取
 * 保证了返回的base url 如果是h5地址的base url则以/h5 结尾
 * 但是如短链、服务器地址等等这些信息则不会拼接（毕竟是服务器地址嘛）
 * <p>
 * 所有返回的地址，最后都不包含/ ，防止重复拼接
 *
 * @author gonzo
 * @date 2020-07-30 16:21
 **/
public interface DomainFacadeService {

    /**
     * 获取短链的base url
     *
     * @return 短链的base url
     */
    String getShortLinkBaseUrl();

    /**
     * 获取服务器的base url
     *
     * @return 服务器的base url
     */
    String getServerHostBaseUrl();

    /**
     * 获取第三方回调网关的根地址
     *
     * @return 第三方回调网关的根地址
     */
    String getThirdPartyHostBaseUrl();

    /**
     * 获取运营后台服务网关的根地址
     *
     * @return 运营后台服务网关的根地址
     */
    String getManageHostBaseUrl();

    /**
     * 获取应用内嵌H5的基础地址
     *
     * @param srcApp 所属应用
     * @return 内部H5 base url
     */
    String getInnerH5BaseUrl(String srcApp);

    /**
     * 根据请求参数，获取可用的base url信息
     * 必须携带所属应用信息
     *
     * @param param 包含场景、基础参数的请求参数
     * @return 包含了域名、baseUrl（如果有需要则会拼接）的信息
     */
    String getBaseUrlInfo(DomainFetchParam param);

    /**
     * 根据落地页获取域名信息
     *
     * @return 域名信息
     */
    String getBaseUrlByDomainViewScene(DomainScene domainScene, DomainViewScene domainViewScene);
}
