package com.bxm.foundation.base.facade.service;

import com.bxm.foundation.base.facade.bo.EquipmentBO;
import com.bxm.foundation.base.facade.dto.EquipmentAppInfoDTO;

import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/6/16 10:37 上午
 */
public interface EquipmentFacadeService {

    /**
     * 上报设备信息,返回0则说明提供的唯一标识无效
     *
     * @param equipmentBO 设备信息入参
     * @return 返回结果
     */
    Long reportEquipment(EquipmentBO equipmentBO);

    /**
     * 判断是否是新用户（是否是激活设备的第一天）
     *
     * @param equipmentId 设备id
     * @return 是否是新用户
     */
    Boolean judgeNewUser(Long equipmentId);

    /**
     * 获取设备上的安装列表
     *
     * @param equipmentId 设备ID
     * @return 安装列表
     */
    List<EquipmentAppInfoDTO> queryInstallAppList(Long equipmentId);


    /**
     * 获取真正设备id
     *
     * @param equipmentId 设备id
     * @return {@link Long}
     */
    Long getTrueEquipmentId(Long equipmentId);
}