package com.bxm.foundation.base.facade.service;

import java.util.List;

/**
 * 敏感词服务接口，用于判断提交的内容中是否存在敏感词
 * 用于评论提交、发帖等用途，后续可扩展不同的题库对应不同的处理策略
 *
 * @author liujia
 */
public interface SensitiveWordFacadeService {

    /**
     * 判断字符串中是否存在敏感词
     *
     * @param source 原始字符串
     * @return true表示存在敏感词
     */
    boolean contains(String source);

    /**
     * 匹配文本中是否存在敏感词
     *
     * @param source       原始文本
     * @param skipStopWord 是否跳过停顿处（去除无意义的符号，防止出现通过空格隔开的情况）
     * @param searchAll    是否遍历所有的内容，如果为false，找到第一个敏感词就会返回
     * @return 所有匹配的敏感词
     */
    List<String> match(String source, boolean skipStopWord, boolean searchAll);
}
