/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.HanaCallableStatement;
import com.sap.db.jdbc.HanaCallableStatementClean;
import com.sap.db.jdbc.HanaCallableStatementFinalize;
import com.sap.db.jdbc.HanaCallableStatementPhantom;
import com.sap.db.jdbc.HanaPreparedStatement;
import com.sap.db.jdbc.HanaPreparedStatementClean;
import com.sap.db.jdbc.HanaPreparedStatementFinalize;
import com.sap.db.jdbc.HanaPreparedStatementPhantom;
import com.sap.db.jdbc.Host;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.ShardingKey;
import java.util.List;
import java.util.Properties;

@ThreadSafe
public abstract class ConnectionSapDB9
extends ConnectionSapDB {
    protected ConnectionSapDB9(Tracer tracer, Session session, Properties properties, ConnectionProperties connectionProperties, List<Host> list) throws SQLException {
        super(tracer, session, properties, connectionProperties, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void beginRequest() throws SQLException {
        boolean bl = this._tracer.on();
        boolean bl2 = this._tracer.pon();
        TraceRecord traceRecord = bl2 ? this._newTraceRecord("beginRequest") : null;
        try {
            if (bl) {
                this._tracer.printCall(this, "beginRequest", new Object[0]);
            }
        }
        finally {
            if (bl2) {
                this._publish(traceRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void endRequest() throws SQLException {
        boolean bl = this._tracer.on();
        boolean bl2 = this._tracer.pon();
        TraceRecord traceRecord = bl2 ? this._newTraceRecord("endRequest") : null;
        try {
            if (bl) {
                this._tracer.printCall(this, "endRequest", new Object[0]);
            }
        }
        finally {
            if (bl2) {
                this._publish(traceRecord);
            }
        }
    }

    @Override
    public synchronized void setShardingKey(ShardingKey shardingKey) throws SQLException {
        boolean bl = this._tracer.on();
        boolean bl2 = this._tracer.pon();
        TraceRecord traceRecord = bl2 ? this._newTraceRecord("setShardingKey") : null;
        try {
            try {
                if (bl) {
                    this._tracer.printCall(this, "setShardingKey", shardingKey);
                }
                throw ConnectionSapDB9._getUnsupportedMethodException("setShardingKey( ShardingKey )");
            }
            catch (SQLException sQLException) {
                if (bl) {
                    this._tracer.printException(sQLException);
                }
                if (bl2) {
                    traceRecord.setException(sQLException);
                }
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            if (bl2) {
                this._publish(traceRecord);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void setShardingKey(ShardingKey shardingKey, ShardingKey shardingKey2) throws SQLException {
        boolean bl = this._tracer.on();
        boolean bl2 = this._tracer.pon();
        TraceRecord traceRecord = bl2 ? this._newTraceRecord("setShardingKey") : null;
        try {
            try {
                if (bl) {
                    this._tracer.printCall(this, "setShardingKey", shardingKey, shardingKey2);
                }
                throw ConnectionSapDB9._getUnsupportedMethodException("setShardingKey( ShardingKey, ShardingKey )");
            }
            catch (SQLException sQLException) {
                if (bl) {
                    this._tracer.printException(sQLException);
                }
                if (bl2) {
                    traceRecord.setException(sQLException);
                }
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            if (bl2) {
                this._publish(traceRecord);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean setShardingKeyIfValid(ShardingKey shardingKey, int n) throws SQLException {
        boolean bl = this._tracer.on();
        boolean bl2 = this._tracer.pon();
        TraceRecord traceRecord = bl2 ? this._newTraceRecord("setShardingKeyIfValid") : null;
        try {
            try {
                if (bl) {
                    this._tracer.printCall(this, "setShardingKeyIfValid", shardingKey, n);
                }
                throw ConnectionSapDB9._getUnsupportedMethodException("setShardingKeyIfValid( ShardingKey, int )");
            }
            catch (SQLException sQLException) {
                if (bl) {
                    this._tracer.printException(sQLException);
                }
                if (bl2) {
                    traceRecord.setException(sQLException);
                }
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            if (bl2) {
                this._publish(traceRecord);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized boolean setShardingKeyIfValid(ShardingKey shardingKey, ShardingKey shardingKey2, int n) throws SQLException {
        boolean bl = this._tracer.on();
        boolean bl2 = this._tracer.pon();
        TraceRecord traceRecord = bl2 ? this._newTraceRecord("setShardingKeyIfValid") : null;
        try {
            try {
                if (bl) {
                    this._tracer.printCall(this, "setShardingKeyIfValid", shardingKey, shardingKey2, n);
                }
                throw ConnectionSapDB9._getUnsupportedMethodException("setShardingKeyIfValid( ShardingKey, ShardingKey, int )");
            }
            catch (SQLException sQLException) {
                if (bl) {
                    this._tracer.printException(sQLException);
                }
                if (bl2) {
                    traceRecord.setException(sQLException);
                }
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            if (bl2) {
                this._publish(traceRecord);
            }
            throw throwable;
        }
    }

    @Override
    protected PreparedStatement _prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this._assertOpen();
        if (Driver._createPhantomClass(this._connectionProperties)) {
            return HanaPreparedStatementPhantom.newInstance(this._tracer, this, string, n, n2, n3, false, false);
        }
        if (Driver._createCleanerClass(this._connectionProperties)) {
            return HanaPreparedStatementClean.newInstance(this._tracer, this, string, n, n2, n3, false, false);
        }
        if (Driver._createFinalizerClass(this._connectionProperties)) {
            return HanaPreparedStatementFinalize.newInstance(this._tracer, this, string, n, n2, n3, false, false);
        }
        return HanaPreparedStatement.newInstance(this._tracer, this, string, n, n2, n3, false, false);
    }

    @Override
    protected CallableStatement _prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this._assertOpen();
        if (Driver._createPhantomClass(this._connectionProperties)) {
            return HanaCallableStatementPhantom.newInstance(this._tracer, this, string, n, n2, n3, false, false);
        }
        if (Driver._createCleanerClass(this._connectionProperties)) {
            return HanaCallableStatementClean.newInstance(this._tracer, this, string, n, n2, n3, false, false);
        }
        if (Driver._createFinalizerClass(this._connectionProperties)) {
            return HanaCallableStatementFinalize.newInstance(this._tracer, this, string, n, n2, n3, false, false);
        }
        return HanaCallableStatement.newInstance(this._tracer, this, string, n, n2, n3, false, false);
    }

    static {
        Driver.checkJavaVersionMinimum9();
    }
}

