/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.exceptions.SQLClientInfoExceptionSapDB;
import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

@NotThreadSafe
class ClientInfo {
    private final Properties _properties = new Properties();

    protected ClientInfo() {
    }

    protected boolean _hasProperties() {
        return !this._properties.isEmpty();
    }

    protected Properties _getProperties() {
        return this._properties;
    }

    protected String _getProperty(String key) {
        if (key == null) {
            return null;
        }
        return this._properties.getProperty(key);
    }

    protected void _setProperties(Properties properties) throws SQLClientInfoException {
        this._properties.clear();
        if (properties == null || properties.isEmpty()) {
            return;
        }
        LinkedHashMap<String, ClientInfoStatus> invalidKeys = null;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            String keyString = (String)(key != null ? (key instanceof String ? key : key.toString()) : null);
            String valueString = (String)(value != null ? (value instanceof String ? value : value.toString()) : null);
            try {
                this._setProperty(keyString, valueString);
            }
            catch (SQLClientInfoException e) {
                if (invalidKeys == null) {
                    invalidKeys = new LinkedHashMap<String, ClientInfoStatus>();
                }
                invalidKeys.put(keyString, ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            }
        }
        if (invalidKeys != null) {
            throw new SQLClientInfoExceptionSapDB(invalidKeys);
        }
    }

    protected void _setProperty(String key, String value) throws SQLClientInfoException {
        if (key == null) {
            throw new SQLClientInfoExceptionSapDB(Collections.singletonMap(key, ClientInfoStatus.REASON_UNKNOWN_PROPERTY));
        }
        if (value == null) {
            this._properties.remove(key);
        } else {
            this._properties.setProperty(key, value);
        }
    }
}

