/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;

@Immutable
public enum RteReturnCode {
    SQLOK(0, -708),
    SQLNOTOK(1, -807),
    SQLTASKLIMIT(2, -9807),
    SQLTIMEOUT(3, 700),
    SQLCRASH(4, 800),
    SQLSTART_REQUIRED(5, -813),
    SQLSHUTDOWN(6, -708),
    SQLSEND_LINE_DOWN(7, -708),
    SQLRECEIVE_LINE_DOWN(8, -708),
    SQLPACKETLIMIT(9, -708),
    SQLRELEASED(10, -807),
    SQLWOULDBLOCK(11, -708),
    SQLUNKNOWN_REQUEST(12, -708),
    SQLSERVER_OR_DB_UNKNOWN(13, -709),
    REQUEST_UNKNOWN(14, -709),
    UNKNOWN(-1, 0);

    private static final RteReturnCode[] VALUES;
    private final int _communicationErrorCode;

    public static RteReturnCode decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : UNKNOWN;
    }

    public static String getDisplayName(int value) {
        return RteReturnCode.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private RteReturnCode(int value, int communicationErrorCode) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
        this._communicationErrorCode = communicationErrorCode;
    }

    public int getValue() {
        return this.ordinal();
    }

    public int getCommunicationErrorCode() {
        return this._communicationErrorCode;
    }

    static {
        VALUES = RteReturnCode.values();
    }
}

