/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;
import java.util.Map;
import java.util.TreeMap;

@Immutable
public enum DistributionMode {
    Off(0, false, false, "OFF"),
    Connection(1, true, false, "CONNECTION"),
    Statement(2, false, true, "STATEMENT", "STATEMENT_ONLY"),
    All(3, true, true, "ALL"),
    Unknown(-1, false, false, new String[0]);

    private static final DistributionMode[] VALUES;
    private static Map<String, DistributionMode> NAME_MAP;
    private final boolean _isConnectionRouting;
    private final boolean _isStatementRouting;
    private final String[] _names;

    public static DistributionMode decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : Unknown;
    }

    public static DistributionMode decode(String name) {
        DistributionMode value = NAME_MAP.get(name);
        return value != null ? value : Unknown;
    }

    public static String getDisplayName(int value) {
        return DistributionMode.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private DistributionMode(int value, boolean isConnectionRouting, boolean isStatementRouting, String ... names) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
        this._isConnectionRouting = isConnectionRouting;
        this._isStatementRouting = isStatementRouting;
        this._names = names;
    }

    public int getValue() {
        return this.ordinal();
    }

    public boolean isConnectionRouting() {
        return this._isConnectionRouting;
    }

    public boolean isStatementRouting() {
        return this._isStatementRouting;
    }

    static {
        VALUES = DistributionMode.values();
        NAME_MAP = new TreeMap<String, DistributionMode>(String.CASE_INSENSITIVE_ORDER);
        for (DistributionMode value : VALUES) {
            for (String name : value._names) {
                NAME_MAP.put(name, value);
            }
        }
    }
}

