/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum PartitionMethod {
    None(0),
    RoundRobin(1),
    Hash(2),
    Range(3),
    HashWithoutSplitBatch(4),
    RangeWithoutSplitBatch(5);

    private static final PartitionMethod[] VALUES;

    public static PartitionMethod decode(int value) {
        return value >= 0 && value < VALUES.length ? VALUES[value] : None;
    }

    public static String getDisplayName(int value) {
        return PartitionMethod.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private PartitionMethod(int value) {
        if (value != this.ordinal()) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = PartitionMethod.values();
    }
}

