/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum TransactionState {
    None(0),
    ReadTransaction(1),
    WriteTransaction(2),
    DistributedTransaction(3),
    Unknown(-1);

    private static final TransactionState[] VALUES;

    public static TransactionState decode(int value) {
        return value >= 0 && value < VALUES.length - 1 ? VALUES[value] : Unknown;
    }

    public static String getDisplayName(int value) {
        return TransactionState.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private TransactionState(int value) {
        if (value != this.ordinal() && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = TransactionState.values();
    }
}

