/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.AesCbc;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;
import com.sap.db.util.RsaOaep;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import java.security.Key;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;

@NotThreadSafe
class LDAPAuthentication
extends AbstractAuthenticationMethod {
    static final String METHOD_NAME = "LDAP";
    private static final int CLIENT_NONCE_LENGTH = 64;
    private static final int CLIENT_NONCE_LENGTH_INDICATOR_LENGTH = HAuthenticationPart.getLengthIndicatorLength(64);
    private static final byte[] CAPABILITIES = new byte[]{1, 0, 0, 0, 0, 0, 0, 0};
    private static final int CAPABILITIES_LENGTH = CAPABILITIES.length;
    private static final int CAPABILITIES_LENGTH_INDICATOR_LENGTH = HAuthenticationPart.getLengthIndicatorLength(CAPABILITIES_LENGTH);
    private static final int CLIENT_CHALLENGE_LENGTH = 2 + CLIENT_NONCE_LENGTH_INDICATOR_LENGTH + 64 + CAPABILITIES_LENGTH_INDICATOR_LENGTH + CAPABILITIES_LENGTH;
    private static final int SESSION_KEY_LENGTH = 32;
    private byte[] _clientNonce;
    private byte[] _serverNonce;
    private String _serverPublicKey;

    LDAPAuthentication() {
    }

    @Override
    String getMethodName() {
        return METHOD_NAME;
    }

    @Override
    byte[] getInitialData(byte[] passwd) throws SQLException {
        this._clientNonce = LDAPAuthentication._fillRandom(new byte[64]);
        byte[] clientChallenge = new byte[CLIENT_CHALLENGE_LENGTH];
        int offset = 0;
        ByteUtils.putShort(2, clientChallenge, offset);
        HAuthenticationPart.putLengthIndicator(64, clientChallenge, offset += 2);
        ByteUtils.putBytes(this._clientNonce, clientChallenge, offset += CLIENT_NONCE_LENGTH_INDICATOR_LENGTH);
        HAuthenticationPart.putLengthIndicator(CAPABILITIES_LENGTH, clientChallenge, offset += 64);
        ByteUtils.putBytes(CAPABILITIES, clientChallenge, offset += CAPABILITIES_LENGTH_INDICATOR_LENGTH);
        return clientChallenge;
    }

    @Override
    byte[] getFinalData(String passwd) throws SQLException {
        int serverNonceLength = this._serverNonce.length;
        byte[] sessionKey = LDAPAuthentication._fillRandom(new byte[32]);
        byte[] sessionKeyPlusServerNonce = new byte[32 + serverNonceLength];
        ByteUtils.putBytes(sessionKey, sessionKeyPlusServerNonce, 0);
        ByteUtils.putBytes(this._serverNonce, sessionKeyPlusServerNonce, 32);
        Key rsaPublicKey = RsaOaep.generatePublicKeyFromBytes(Base64Utils.decodePublicKey(this._serverPublicKey), "RSA-OAEP-2048");
        byte[] encryptedSessionKeyPlusServerNonce = RsaOaep.encrypt(rsaPublicKey, sessionKeyPlusServerNonce);
        int encryptedSessionKeyPlusServerNonceLength = encryptedSessionKeyPlusServerNonce.length;
        int encryptedSessionKeyPlusServerNonceLengthIndicatorLength = HAuthenticationPart.getLengthIndicatorLength(encryptedSessionKeyPlusServerNonceLength);
        byte[] passwdBytes = Cesu8Utils.getBytes(passwd);
        int passwdBytesLength = passwdBytes.length;
        byte[] passwdPlusServerNonce = new byte[passwdBytesLength + 1 + serverNonceLength];
        ByteUtils.putBytes(passwdBytes, passwdPlusServerNonce, 0);
        ByteUtils.putByte(0, passwdPlusServerNonce, passwdBytesLength);
        ByteUtils.putBytes(this._serverNonce, passwdPlusServerNonce, passwdBytesLength + 1);
        Key aesKey = AesCbc.getKey(sessionKey, "AES-256-CBC");
        byte[] encryptedPasswdPlusServerNonce = AesCbc.encrypt(aesKey, passwdPlusServerNonce, new IvParameterSpec(this._serverNonce, 0, 16));
        int encryptedPasswdPlusServerNonceLength = encryptedPasswdPlusServerNonce.length;
        int encryptedPasswdPlusServerNonceLengthIndicatorLength = HAuthenticationPart.getLengthIndicatorLength(encryptedPasswdPlusServerNonceLength);
        int clientProofLength = 2 + encryptedSessionKeyPlusServerNonceLengthIndicatorLength + encryptedSessionKeyPlusServerNonceLength + encryptedPasswdPlusServerNonceLengthIndicatorLength + encryptedPasswdPlusServerNonceLength;
        byte[] clientProof = new byte[clientProofLength];
        int offset = 0;
        ByteUtils.putShort(2, clientProof, offset);
        HAuthenticationPart.putLengthIndicator(encryptedSessionKeyPlusServerNonceLength, clientProof, offset += 2);
        ByteUtils.putBytes(encryptedSessionKeyPlusServerNonce, clientProof, offset += encryptedSessionKeyPlusServerNonceLengthIndicatorLength);
        HAuthenticationPart.putLengthIndicator(encryptedPasswdPlusServerNonceLength, clientProof, offset += encryptedSessionKeyPlusServerNonceLength);
        ByteUtils.putBytes(encryptedPasswdPlusServerNonce, clientProof, offset += encryptedPasswdPlusServerNonceLengthIndicatorLength);
        return clientProof;
    }

    @Override
    byte[] evaluateAuthenticateReply(HAuthenticationPart authenticationPart, Tracer tracer) throws SQLException {
        HAuthenticationPart part = new HAuthenticationPart(authenticationPart);
        LDAPAuthentication._nextField(part);
        byte[] clientNonce = part.getValueAsBytes();
        if (!Arrays.equals(clientNonce, this._clientNonce)) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
        LDAPAuthentication._nextField(part);
        this._serverNonce = part.getValueAsBytes();
        if (LDAPAuthentication._isZeros(this._serverNonce)) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
        LDAPAuthentication._nextField(part);
        this._serverPublicKey = part.getValueAsString();
        LDAPAuthentication._nextField(part);
        byte[] capabilityResult = part.getValueAsBytes();
        return null;
    }

    @Override
    boolean supportsReconnect() {
        return true;
    }

    private static byte[] _fillRandom(byte[] buffer) {
        SecureRandom srnd = new SecureRandom();
        srnd.nextBytes(buffer);
        return buffer;
    }

    private static void _nextField(HAuthenticationPart subPart) throws SQLException {
        if (!subPart.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
    }

    private static boolean _isZeros(byte[] bytes) {
        for (byte b : bytes) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }
}

