/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.CharsetUtils;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import java.sql.SQLException;

@ThreadSafe
class SessionCookieAuthentication
extends AbstractAuthenticationMethod {
    static final String METHOD_NAME = "SessionCookie";
    private final ConnectionSapDB _connection;

    SessionCookieAuthentication(ConnectionSapDB connection) {
        this._connection = connection;
    }

    @Override
    String getMethodName() {
        return METHOD_NAME;
    }

    @Override
    byte[] getInitialData(byte[] passwd) throws SQLException {
        byte[] cookieRaw = this._connection.getCookie();
        byte[] termID = this._connection.getTermID().getBytes(CharsetUtils.UTF_8);
        int cookieLength = cookieRaw.length;
        int termIDLength = termID.length;
        byte[] combined = new byte[cookieLength + termIDLength];
        System.arraycopy(cookieRaw, 0, combined, 0, cookieLength);
        System.arraycopy(termID, 0, combined, cookieLength, termIDLength);
        return combined;
    }

    @Override
    byte[] getFinalData(String passwd) throws SQLException {
        return new byte[0];
    }

    @Override
    byte[] evaluateAuthenticateReply(HAuthenticationPart authenticationPart, Tracer tracer) throws SQLException {
        return null;
    }

    @Override
    boolean supportsReconnect() {
        return true;
    }
}

