/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.CharacterConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.AesCbc;
import com.sap.db.util.Cesu8Utils;
import java.sql.SQLException;
import java.util.Set;

@ThreadSafe
class AlphanumConverter
extends CharacterConverter {
    private static final int ALPHANUM_LENGTH_MASK = 127;
    private static final int ALPHANUM_PURELY_NUMERIC = 128;

    protected AlphanumConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        int len = this._length + 1;
        int dataLen = this._isEncrypted ? AesCbc.getEncryptedLength(this._isDeterministic ? len : len + 1) : len;
        int dataLengthIndicatorLen = HDataPart.getDataLengthIndicatorLength(dataLen);
        return dataLen + dataLengthIndicatorLen;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) throws SQLException {
        if (this._isEncrypted && !this._isDeterministic) {
            byte[] encrypted = this._getEncryptedBuffer(NON_DETERMINISTIC_NULL_MARKER_ARRAY);
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putNull(DataType.CHAR);
    }

    @Override
    protected String _getValueAsString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        int valueLength;
        int alphanumLength;
        int length;
        int offset;
        byte[] buffer;
        byte[] decrypted;
        byte[] byArray = decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        if (dataPart.isNull(this, controller, decrypted)) {
            return null;
        }
        String prefix = "";
        if (this._isEncrypted) {
            if (this._isDeterministic) {
                decrypted = this._getDecryptedBuffer(dataPart);
                buffer = decrypted;
                offset = 0;
                length = decrypted.length;
            } else {
                buffer = decrypted;
                offset = 1;
                length = decrypted.length - 1;
            }
        } else {
            buffer = dataPart.getRawPacketArray();
            offset = dataPart.getNonNullDataOffset();
            length = dataPart.getNonNullDataLength();
        }
        int flags = buffer[offset] & 0xFF;
        String value = Cesu8Utils.getString(buffer, offset + 1, length - 1);
        if ((flags & 0x80) > 0 && (alphanumLength = flags & 0x7F) > (valueLength = value.length())) {
            int prefixLength = alphanumLength - valueLength;
            prefix = String.format("%0" + prefixLength + "d", 0);
        }
        return prefix + value;
    }
}

