/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum PartitionParameterFunction {
    None(0),
    Year(1),
    Month(2);

    private static final PartitionParameterFunction[] VALUES;

    public static PartitionParameterFunction decode(int value) {
        return value >= 0 && value < VALUES.length ? VALUES[value] : None;
    }

    public static String getDisplayName(int value) {
        return PartitionParameterFunction.decode(value).name() + '(' + String.valueOf(value) + ')';
    }

    private PartitionParameterFunction(int value) {
        if (value != this.ordinal()) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = PartitionParameterFunction.values();
    }
}

