/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.sql.SQLException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

@Immutable
public final class RsaOaep {
    public static final String JAVA_ALGORITHM_NAME = "RSA";
    public static final String HANA_ALGORITHM_NAME = "RSA-OAEP-2048";
    public static final String TRANSFORMATION_NAME = "RSA/ECB/OAEPPadding";
    private static final ThreadLocal<Cipher> CIPHER_RSA_ECB_OAEP = new ThreadLocal<Cipher>(){

        @Override
        public Cipher initialValue() {
            try {
                return Cipher.getInstance(RsaOaep.TRANSFORMATION_NAME);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("error.crypto.extension.not_installed", e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException("error.crypto.extension.not_installed", e);
            }
        }
    };
    private final KeyPair _keyPair;

    public static Key generatePublicKeyFromBytes(byte[] publicKeyBytes, String algorithmName) throws SQLException {
        if (publicKeyBytes == null) {
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RsaOaep._getJavaAlgorithmName(algorithmName));
            return keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.keygeneration.failed", e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.keygeneration.failed", e.getMessage());
        }
    }

    public static Key generatePrivateKeyFromBytes(byte[] privateKeyBytes, String algorithmName) throws SQLException {
        if (privateKeyBytes == null) {
            return null;
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(RsaOaep._getJavaAlgorithmName(algorithmName));
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.keygeneration.failed", e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.keygeneration.failed", e.getMessage());
        }
    }

    public static byte[] encrypt(Key publicKey, byte[] input) throws SQLException {
        byte[] output;
        try {
            Cipher cipher = CIPHER_RSA_ECB_OAEP.get();
            cipher.init(1, publicKey);
            output = cipher.doFinal(input);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        catch (BadPaddingException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        return output;
    }

    public static byte[] decrypt(Key privateKey, byte[] input) throws SQLException {
        byte[] output;
        try {
            Cipher cipher = CIPHER_RSA_ECB_OAEP.get();
            cipher.init(2, privateKey);
            output = cipher.doFinal(input);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", e.getMessage());
        }
        catch (BadPaddingException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", e.getMessage());
        }
        return output;
    }

    public RsaOaep(int keySize, String algorithmName) throws SQLException {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(RsaOaep._getJavaAlgorithmName(algorithmName));
            kpg.initialize(keySize);
            this._keyPair = kpg.genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.keygeneration.failed", e.getMessage());
        }
    }

    public Key getPublicKey() {
        return this._keyPair.getPublic();
    }

    public Key getPrivateKey() {
        return this._keyPair.getPrivate();
    }

    private static String _getJavaAlgorithmName(String algorithmName) {
        if (algorithmName.equalsIgnoreCase(HANA_ALGORITHM_NAME)) {
            return JAVA_ALGORITHM_NAME;
        }
        return "UNKNOWN";
    }
}

