/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.ws;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Connection;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.internal.Internal;
import com.squareup.okhttp.internal.NamedRunnable;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.ws.RealWebSocket;
import com.squareup.okhttp.ws.WebSocketListener;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class WebSocketCall {
    private final Request request;
    private final Call call;
    private final Random random;
    private final String key;

    public static WebSocketCall create(OkHttpClient client, Request request) {
        return new WebSocketCall(client, request);
    }

    protected WebSocketCall(OkHttpClient client, Request request) {
        this(client, request, new SecureRandom());
    }

    WebSocketCall(OkHttpClient client, Request request, Random random) {
        String httpUrl;
        if (!"GET".equals(request.method())) {
            throw new IllegalArgumentException("Request must be GET: " + request.method());
        }
        String url = request.urlString();
        if (url.startsWith("ws://")) {
            httpUrl = "http://" + url.substring(5);
        } else if (url.startsWith("wss://")) {
            httpUrl = "https://" + url.substring(6);
        } else if (url.startsWith("http://") || url.startsWith("https://")) {
            httpUrl = url;
        } else {
            throw new IllegalArgumentException("Request url must use 'ws', 'wss', 'http', or 'https' scheme: " + url);
        }
        this.random = random;
        byte[] nonce = new byte[16];
        random.nextBytes(nonce);
        this.key = ByteString.of((byte[])nonce).base64();
        client = client.clone();
        client.setProtocols(Collections.singletonList(Protocol.HTTP_1_1));
        this.request = request = request.newBuilder().url(httpUrl).header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").build();
        this.call = client.newCall(request);
    }

    public void enqueue(final WebSocketListener listener) {
        Callback responseCallback = new Callback(){

            public void onResponse(Response response) throws IOException {
                try {
                    WebSocketCall.this.createWebSocket(response, listener);
                }
                catch (IOException e) {
                    listener.onFailure(e);
                }
            }

            public void onFailure(Request request, IOException e) {
                listener.onFailure(e);
            }
        };
        Internal.instance.callEnqueue(this.call, responseCallback, true);
    }

    public void cancel() {
        this.call.cancel();
    }

    private void createWebSocket(Response response, WebSocketListener listener) throws IOException {
        if (response.code() != 101) {
            Internal.instance.callEngineReleaseConnection(this.call);
            throw new ProtocolException("Expected HTTP 101 response but was '" + response.code() + " " + response.message() + "'");
        }
        String headerConnection = response.header("Connection");
        if (!"Upgrade".equalsIgnoreCase(headerConnection)) {
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + headerConnection + "'");
        }
        String headerUpgrade = response.header("Upgrade");
        if (!"websocket".equalsIgnoreCase(headerUpgrade)) {
            throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + headerUpgrade + "'");
        }
        String headerAccept = response.header("Sec-WebSocket-Accept");
        String acceptExpected = Util.shaBase64((String)(this.key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11"));
        if (!acceptExpected.equals(headerAccept)) {
            throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + acceptExpected + "' but was '" + headerAccept + "'");
        }
        Connection connection = Internal.instance.callEngineGetConnection(this.call);
        if (!Internal.instance.clearOwner(connection)) {
            throw new IllegalStateException("Unable to take ownership of connection.");
        }
        Socket socket = connection.getSocket();
        BufferedSource source = Okio.buffer((Source)Okio.source((Socket)socket));
        BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)socket));
        final RealWebSocket webSocket = ConnectionWebSocket.create(response, connection, source, sink, this.random, listener);
        new Thread((Runnable)new NamedRunnable("OkHttp WebSocket reader %s", new Object[]{this.request.urlString()}){

            protected void execute() {
                while (webSocket.readMessage()) {
                }
            }
        }).start();
        Internal.instance.connectionSetOwner(connection, (Object)webSocket);
        listener.onOpen(webSocket, this.request, response);
    }

    private static class ConnectionWebSocket
    extends RealWebSocket {
        private final Connection connection;

        static RealWebSocket create(Response response, Connection connection, BufferedSource source, BufferedSink sink, Random random, WebSocketListener listener) {
            String url = response.request().urlString();
            ThreadPoolExecutor replyExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), Util.threadFactory((String)String.format("OkHttp %s WebSocket", url), (boolean)true));
            replyExecutor.allowCoreThreadTimeOut(true);
            return new ConnectionWebSocket(connection, source, sink, random, (Executor)replyExecutor, listener, url);
        }

        private ConnectionWebSocket(Connection connection, BufferedSource source, BufferedSink sink, Random random, Executor replyExecutor, WebSocketListener listener, String url) {
            super(true, source, sink, random, replyExecutor, listener, url);
            this.connection = connection;
        }

        @Override
        protected void closeConnection() throws IOException {
            Internal.instance.closeIfOwnedBy(this.connection, (Object)this);
        }
    }
}

