package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TbkRelationRefundResponse;

/**
 * TOP API: taobao.tbk.relation.refund request
 * 
 * @author top auto create
 * @since 1.0, 2020.03.23
 */
public class TbkRelationRefundRequest extends BaseTaobaoRequest<TbkRelationRefundResponse> {
	
	

	/** 
	* 参数option
	 */
	private String searchOption;

	public void setSearchOption(String searchOption) {
		this.searchOption = searchOption;
	}

	public void setSearchOption(TopApiRefundRptOption searchOption) {
		this.searchOption = new JSONWriter(false,true).write(searchOption);
	}

	public String getSearchOption() {
		return this.searchOption;
	}

	public String getApiMethodName() {
		return "taobao.tbk.relation.refund";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("search_option", this.searchOption);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkRelationRefundResponse> getResponseClass() {
		return TbkRelationRefundResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 参数option
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopApiRefundRptOption extends TaobaoObject {

	private static final long serialVersionUID = 3894328619396678372L;

	/**
		 * 1代表渠道关系id，2代表会员关系id，3代表渠道加会员
		 */
		@ApiField("biz_type")
		private Long bizType;
		/**
		 * pagenumber
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * pagesize
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 1 表示2方，2表示3方，0表示不限
		 */
		@ApiField("refund_type")
		private Long refundType;
		/**
		 * 1-维权发起时间，2-订单结算时间（正向订单），3-维权完成时间，4-订单创建时间
		 */
		@ApiField("search_type")
		private Long searchType;
		/**
		 * 开始时间
		 */
		@ApiField("start_time")
		private Date startTime;
	

	public Long getBizType() {
			return this.bizType;
		}
		public void setBizType(Long bizType) {
			this.bizType = bizType;
		}
		public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Long getRefundType() {
			return this.refundType;
		}
		public void setRefundType(Long refundType) {
			this.refundType = refundType;
		}
		public Long getSearchType() {
			return this.searchType;
		}
		public void setSearchType(Long searchType) {
			this.searchType = searchType;
		}
		public Date getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Date startTime) {
			this.startTime = startTime;
		}

}


}