package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TbkScInvitecodeGetResponse;

/**
 * TOP API: taobao.tbk.sc.invitecode.get request
 * 
 * @author top auto create
 * @since 1.0, 2019.07.04
 */
public class TbkScInvitecodeGetRequest extends BaseTaobaoRequest<TbkScInvitecodeGetResponse> {
	
	

	/** 
	* 邀请码类型，1 - 渠道邀请，2 - 渠道裂变，3 -会员邀请
	 */
	private Long codeType;

	/** 
	* 渠道推广的物料类型
	 */
	private String relationApp;

	/** 
	* 渠道关系ID
	 */
	private Long relationId;

	public void setCodeType(Long codeType) {
		this.codeType = codeType;
	}

	public Long getCodeType() {
		return this.codeType;
	}

	public void setRelationApp(String relationApp) {
		this.relationApp = relationApp;
	}

	public String getRelationApp() {
		return this.relationApp;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Long getRelationId() {
		return this.relationId;
	}

	public String getApiMethodName() {
		return "taobao.tbk.sc.invitecode.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("code_type", this.codeType);
		txtParams.put("relation_app", this.relationApp);
		txtParams.put("relation_id", this.relationId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TbkScInvitecodeGetResponse> getResponseClass() {
		return TbkScInvitecodeGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(codeType, "codeType");
		RequestCheckUtils.checkNotEmpty(relationApp, "relationApp");
	}
	

}