package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.tbk.order.details.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TbkOrderDetailsGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1518163747369554223L;

	/** 
	 * PublisherOrderDto
	 */
	@ApiField("data")
	private OrderPage data;


	public void setData(OrderPage data) {
		this.data = data;
	}
	public OrderPage getData( ) {
		return this.data;
	}
	
	/**
 * 服务费信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ServiceFeeDto extends TaobaoObject {

	private static final long serialVersionUID = 1511384266673464167L;

	/**
		 * 结算专项服务费
		 */
		@ApiField("share_fee")
		private String shareFee;
		/**
		 * 预估专项服务费
		 */
		@ApiField("share_pre_fee")
		private String sharePreFee;
		/**
		 * 专项服务费率
		 */
		@ApiField("share_relative_rate")
		private String shareRelativeRate;
		/**
		 * 专项服务费来源，122-渠道
		 */
		@ApiField("tk_share_role_type")
		private Long tkShareRoleType;
	

	public String getShareFee() {
			return this.shareFee;
		}
		public void setShareFee(String shareFee) {
			this.shareFee = shareFee;
		}
		public String getSharePreFee() {
			return this.sharePreFee;
		}
		public void setSharePreFee(String sharePreFee) {
			this.sharePreFee = sharePreFee;
		}
		public String getShareRelativeRate() {
			return this.shareRelativeRate;
		}
		public void setShareRelativeRate(String shareRelativeRate) {
			this.shareRelativeRate = shareRelativeRate;
		}
		public Long getTkShareRoleType() {
			return this.tkShareRoleType;
		}
		public void setTkShareRoleType(Long tkShareRoleType) {
			this.tkShareRoleType = tkShareRoleType;
		}

}

	/**
 * PublisherOrderDto
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class PublisherOrderDto extends TaobaoObject {

	private static final long serialVersionUID = 4621846147539971898L;

	/**
		 * 推广位管理下的推广位名称对应的ID，同时也是pid=mm_1_2_3中的“3”这段数字
		 */
		@ApiField("adzone_id")
		private Long adzoneId;
		/**
		 * 推广位管理下的自定义推广位名称
		 */
		@ApiField("adzone_name")
		private String adzoneName;
		/**
		 * 推广者赚取佣金后支付给阿里妈妈的技术服务费用的比率
		 */
		@ApiField("alimama_rate")
		private String alimamaRate;
		/**
		 * 技术服务费=结算金额*收入比率*技术服务费率。推广者赚取佣金后支付给阿里妈妈的技术服务费用
		 */
		@ApiField("alimama_share_fee")
		private String alimamaShareFee;
		/**
		 * 买家拍下付款的金额（不包含运费金额）
		 */
		@ApiField("alipay_total_price")
		private String alipayTotalPrice;
		/**
		 * 口碑子订单号
		 */
		@ApiField("alsc_id")
		private String alscId;
		/**
		 * 口碑父订单号
		 */
		@ApiField("alsc_pid")
		private String alscPid;
		/**
		 * 通过推广链接达到商品、店铺详情页的点击时间
		 */
		@ApiField("click_time")
		private String clickTime;
		/**
		 * 预售时期，用户对预售商品支付的定金金额
		 */
		@ApiField("deposit_price")
		private String depositPrice;
		/**
		 * 产品类型
		 */
		@ApiField("flow_source")
		private String flowSource;
		/**
		 * 订单结算的佣金比率+平台的补贴比率
		 */
		@ApiField("income_rate")
		private String incomeRate;
		/**
		 * 商品所属的根类目，即一级类目的名称
		 */
		@ApiField("item_category_name")
		private String itemCategoryName;
		/**
		 * 商品id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * 商品图片
		 */
		@ApiField("item_img")
		private String itemImg;
		/**
		 * 商品链接
		 */
		@ApiField("item_link")
		private String itemLink;
		/**
		 * 商品数量
		 */
		@ApiField("item_num")
		private Long itemNum;
		/**
		 * 商品单价
		 */
		@ApiField("item_price")
		private String itemPrice;
		/**
		 * 商品标题
		 */
		@ApiField("item_title")
		private String itemTitle;
		/**
		 * 订单所属平台类型，包括天猫、淘宝、聚划算等
		 */
		@ApiField("order_type")
		private String orderType;
		/**
		 * 买家确认收货的付款金额（不包含运费金额）
		 */
		@ApiField("pay_price")
		private String payPrice;
		/**
		 * 推广者的会员id
		 */
		@ApiField("pub_id")
		private Long pubId;
		/**
		 * 结算预估收入=结算金额*提成。以买家确认收货的付款金额为基数，预估您可能获得的收入。因买家退款、您违规推广等原因，可能与您最终收入不一致。最终收入以月结后您实际收到的为准
		 */
		@ApiField("pub_share_fee")
		private String pubShareFee;
		/**
		 * 付款预估收入=付款金额*提成。指买家付款金额为基数，预估您可能获得的收入。因买家退款等原因，可能与结算预估收入不一致
		 */
		@ApiField("pub_share_pre_fee")
		private String pubSharePreFee;
		/**
		 * 从结算佣金中分得的收益比率
		 */
		@ApiField("pub_share_rate")
		private String pubShareRate;
		/**
		 * 维权标签，0 含义为非维权 1 含义为维权订单
		 */
		@ApiField("refund_tag")
		private Long refundTag;
		/**
		 * 渠道关系id
		 */
		@ApiField("relation_id")
		private Long relationId;
		/**
		 * 掌柜旺旺
		 */
		@ApiField("seller_nick")
		private String sellerNick;
		/**
		 * 店铺名称
		 */
		@ApiField("seller_shop_title")
		private String sellerShopTitle;
		/**
		 * 服务费信息
		 */
		@ApiListField("service_fee_dto_list")
		@ApiField("service_fee_dto")
		private List<ServiceFeeDto> serviceFeeDtoList;
		/**
		 * 媒体管理下的ID，同时也是pid=mm_1_2_3中的“2”这段数字
		 */
		@ApiField("site_id")
		private Long siteId;
		/**
		 * 媒体管理下的对应ID的自定义名称
		 */
		@ApiField("site_name")
		private String siteName;
		/**
		 * 会员运营id
		 */
		@ApiField("special_id")
		private Long specialId;
		/**
		 * 补贴金额=结算金额*补贴比率
		 */
		@ApiField("subsidy_fee")
		private String subsidyFee;
		/**
		 * 平台给与的补贴比率，如天猫、淘宝、聚划算等
		 */
		@ApiField("subsidy_rate")
		private String subsidyRate;
		/**
		 * 平台出资方，如天猫、淘宝、或聚划算等
		 */
		@ApiField("subsidy_type")
		private String subsidyType;
		/**
		 * 预售时期，用户对预售商品支付定金的付款时间
		 */
		@ApiField("tb_deposit_time")
		private String tbDepositTime;
		/**
		 * 订单在淘宝拍下付款的时间
		 */
		@ApiField("tb_paid_time")
		private String tbPaidTime;
		/**
		 * 成交平台
		 */
		@ApiField("terminal_type")
		private String terminalType;
		/**
		 * 结算内容专项服务费：内容场景专项技术服务费，内容推广者在内容场景进行推广需要支付给阿里妈妈专项的技术服务费用。专项服务费＝结算金额＊专项服务费率。
		 */
		@ApiField("tk_commission_fee_for_media_platform")
		private String tkCommissionFeeForMediaPlatform;
		/**
		 * 预估内容专项服务费：内容场景专项技术服务费，内容推广者在内容场景进行推广需要支付给阿里妈妈专项的技术服务费用。专项服务费＝付款金额＊专项服务费率。
		 */
		@ApiField("tk_commission_pre_fee_for_media_platform")
		private String tkCommissionPreFeeForMediaPlatform;
		/**
		 * 内容专项服务费率：内容场景专项技术服务费率，内容推广者在内容场景进行推广需要按结算金额支付一定比例给阿里妈妈作为内容场景专项技术服务费，用于提供与内容平台实现产品技术对接等服务。
		 */
		@ApiField("tk_commission_rate_for_media_platform")
		private String tkCommissionRateForMediaPlatform;
		/**
		 * 订单创建的时间，该时间同步淘宝，可能会略晚于买家在淘宝的订单创建时间
		 */
		@ApiField("tk_create_time")
		private String tkCreateTime;
		/**
		 * 预售时期，用户对预售商品支付定金的付款时间，可能略晚于在淘宝付定金时间
		 */
		@ApiField("tk_deposit_time")
		private String tkDepositTime;
		/**
		 * 订单确认收货后且商家完成佣金支付的时间
		 */
		@ApiField("tk_earning_time")
		private String tkEarningTime;
		/**
		 * 二方：佣金收益的第一归属者； 三方：从其他淘宝客佣金中进行分成的推广者
		 */
		@ApiField("tk_order_role")
		private Long tkOrderRole;
		/**
		 * 订单付款的时间，该时间同步淘宝，可能会略晚于买家在淘宝的订单创建时间
		 */
		@ApiField("tk_paid_time")
		private String tkPaidTime;
		/**
		 * 已付款：指订单已付款，但还未确认收货 已收货：指订单已确认收货，但商家佣金未支付 已结算：指订单已确认收货，且商家佣金已支付成功 已失效：指订单关闭订单佣金小于0.01元，订单关闭主要有：1）买家超时未付款； 2）买家付款前，买家卖家取消了订单；3）订单付款后发起售中退款成功；3：订单结算，12：订单付款， 13：订单失效，14：订单成功
		 */
		@ApiField("tk_status")
		private Long tkStatus;
		/**
		 * 提成=收入比率*分成比率。指实际获得收益的比率
		 */
		@ApiField("tk_total_rate")
		private String tkTotalRate;
		/**
		 * 佣金金额=结算金额*佣金比率
		 */
		@ApiField("total_commission_fee")
		private String totalCommissionFee;
		/**
		 * 佣金比率
		 */
		@ApiField("total_commission_rate")
		private String totalCommissionRate;
		/**
		 * 买家通过购物车购买的每个商品对应的订单编号，此订单编号并未在淘宝买家后台透出
		 */
		@ApiField("trade_id")
		private String tradeId;
		/**
		 * 买家在淘宝后台显示的订单编号
		 */
		@ApiField("trade_parent_id")
		private String tradeParentId;
		/**
		 * unid
		 */
		@ApiField("unid")
		private String unid;
	

	public Long getAdzoneId() {
			return this.adzoneId;
		}
		public void setAdzoneId(Long adzoneId) {
			this.adzoneId = adzoneId;
		}
		public String getAdzoneName() {
			return this.adzoneName;
		}
		public void setAdzoneName(String adzoneName) {
			this.adzoneName = adzoneName;
		}
		public String getAlimamaRate() {
			return this.alimamaRate;
		}
		public void setAlimamaRate(String alimamaRate) {
			this.alimamaRate = alimamaRate;
		}
		public String getAlimamaShareFee() {
			return this.alimamaShareFee;
		}
		public void setAlimamaShareFee(String alimamaShareFee) {
			this.alimamaShareFee = alimamaShareFee;
		}
		public String getAlipayTotalPrice() {
			return this.alipayTotalPrice;
		}
		public void setAlipayTotalPrice(String alipayTotalPrice) {
			this.alipayTotalPrice = alipayTotalPrice;
		}
		public String getAlscId() {
			return this.alscId;
		}
		public void setAlscId(String alscId) {
			this.alscId = alscId;
		}
		public String getAlscPid() {
			return this.alscPid;
		}
		public void setAlscPid(String alscPid) {
			this.alscPid = alscPid;
		}
		public String getClickTime() {
			return this.clickTime;
		}
		public void setClickTime(String clickTime) {
			this.clickTime = clickTime;
		}
		public String getDepositPrice() {
			return this.depositPrice;
		}
		public void setDepositPrice(String depositPrice) {
			this.depositPrice = depositPrice;
		}
		public String getFlowSource() {
			return this.flowSource;
		}
		public void setFlowSource(String flowSource) {
			this.flowSource = flowSource;
		}
		public String getIncomeRate() {
			return this.incomeRate;
		}
		public void setIncomeRate(String incomeRate) {
			this.incomeRate = incomeRate;
		}
		public String getItemCategoryName() {
			return this.itemCategoryName;
		}
		public void setItemCategoryName(String itemCategoryName) {
			this.itemCategoryName = itemCategoryName;
		}
		public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public String getItemImg() {
			return this.itemImg;
		}
		public void setItemImg(String itemImg) {
			this.itemImg = itemImg;
		}
		public String getItemLink() {
			return this.itemLink;
		}
		public void setItemLink(String itemLink) {
			this.itemLink = itemLink;
		}
		public Long getItemNum() {
			return this.itemNum;
		}
		public void setItemNum(Long itemNum) {
			this.itemNum = itemNum;
		}
		public String getItemPrice() {
			return this.itemPrice;
		}
		public void setItemPrice(String itemPrice) {
			this.itemPrice = itemPrice;
		}
		public String getItemTitle() {
			return this.itemTitle;
		}
		public void setItemTitle(String itemTitle) {
			this.itemTitle = itemTitle;
		}
		public String getOrderType() {
			return this.orderType;
		}
		public void setOrderType(String orderType) {
			this.orderType = orderType;
		}
		public String getPayPrice() {
			return this.payPrice;
		}
		public void setPayPrice(String payPrice) {
			this.payPrice = payPrice;
		}
		public Long getPubId() {
			return this.pubId;
		}
		public void setPubId(Long pubId) {
			this.pubId = pubId;
		}
		public String getPubShareFee() {
			return this.pubShareFee;
		}
		public void setPubShareFee(String pubShareFee) {
			this.pubShareFee = pubShareFee;
		}
		public String getPubSharePreFee() {
			return this.pubSharePreFee;
		}
		public void setPubSharePreFee(String pubSharePreFee) {
			this.pubSharePreFee = pubSharePreFee;
		}
		public String getPubShareRate() {
			return this.pubShareRate;
		}
		public void setPubShareRate(String pubShareRate) {
			this.pubShareRate = pubShareRate;
		}
		public Long getRefundTag() {
			return this.refundTag;
		}
		public void setRefundTag(Long refundTag) {
			this.refundTag = refundTag;
		}
		public Long getRelationId() {
			return this.relationId;
		}
		public void setRelationId(Long relationId) {
			this.relationId = relationId;
		}
		public String getSellerNick() {
			return this.sellerNick;
		}
		public void setSellerNick(String sellerNick) {
			this.sellerNick = sellerNick;
		}
		public String getSellerShopTitle() {
			return this.sellerShopTitle;
		}
		public void setSellerShopTitle(String sellerShopTitle) {
			this.sellerShopTitle = sellerShopTitle;
		}
		public List<ServiceFeeDto> getServiceFeeDtoList() {
			return this.serviceFeeDtoList;
		}
		public void setServiceFeeDtoList(List<ServiceFeeDto> serviceFeeDtoList) {
			this.serviceFeeDtoList = serviceFeeDtoList;
		}
		public Long getSiteId() {
			return this.siteId;
		}
		public void setSiteId(Long siteId) {
			this.siteId = siteId;
		}
		public String getSiteName() {
			return this.siteName;
		}
		public void setSiteName(String siteName) {
			this.siteName = siteName;
		}
		public Long getSpecialId() {
			return this.specialId;
		}
		public void setSpecialId(Long specialId) {
			this.specialId = specialId;
		}
		public String getSubsidyFee() {
			return this.subsidyFee;
		}
		public void setSubsidyFee(String subsidyFee) {
			this.subsidyFee = subsidyFee;
		}
		public String getSubsidyRate() {
			return this.subsidyRate;
		}
		public void setSubsidyRate(String subsidyRate) {
			this.subsidyRate = subsidyRate;
		}
		public String getSubsidyType() {
			return this.subsidyType;
		}
		public void setSubsidyType(String subsidyType) {
			this.subsidyType = subsidyType;
		}
		public String getTbDepositTime() {
			return this.tbDepositTime;
		}
		public void setTbDepositTime(String tbDepositTime) {
			this.tbDepositTime = tbDepositTime;
		}
		public String getTbPaidTime() {
			return this.tbPaidTime;
		}
		public void setTbPaidTime(String tbPaidTime) {
			this.tbPaidTime = tbPaidTime;
		}
		public String getTerminalType() {
			return this.terminalType;
		}
		public void setTerminalType(String terminalType) {
			this.terminalType = terminalType;
		}
		public String getTkCommissionFeeForMediaPlatform() {
			return this.tkCommissionFeeForMediaPlatform;
		}
		public void setTkCommissionFeeForMediaPlatform(String tkCommissionFeeForMediaPlatform) {
			this.tkCommissionFeeForMediaPlatform = tkCommissionFeeForMediaPlatform;
		}
		public String getTkCommissionPreFeeForMediaPlatform() {
			return this.tkCommissionPreFeeForMediaPlatform;
		}
		public void setTkCommissionPreFeeForMediaPlatform(String tkCommissionPreFeeForMediaPlatform) {
			this.tkCommissionPreFeeForMediaPlatform = tkCommissionPreFeeForMediaPlatform;
		}
		public String getTkCommissionRateForMediaPlatform() {
			return this.tkCommissionRateForMediaPlatform;
		}
		public void setTkCommissionRateForMediaPlatform(String tkCommissionRateForMediaPlatform) {
			this.tkCommissionRateForMediaPlatform = tkCommissionRateForMediaPlatform;
		}
		public String getTkCreateTime() {
			return this.tkCreateTime;
		}
		public void setTkCreateTime(String tkCreateTime) {
			this.tkCreateTime = tkCreateTime;
		}
		public String getTkDepositTime() {
			return this.tkDepositTime;
		}
		public void setTkDepositTime(String tkDepositTime) {
			this.tkDepositTime = tkDepositTime;
		}
		public String getTkEarningTime() {
			return this.tkEarningTime;
		}
		public void setTkEarningTime(String tkEarningTime) {
			this.tkEarningTime = tkEarningTime;
		}
		public Long getTkOrderRole() {
			return this.tkOrderRole;
		}
		public void setTkOrderRole(Long tkOrderRole) {
			this.tkOrderRole = tkOrderRole;
		}
		public String getTkPaidTime() {
			return this.tkPaidTime;
		}
		public void setTkPaidTime(String tkPaidTime) {
			this.tkPaidTime = tkPaidTime;
		}
		public Long getTkStatus() {
			return this.tkStatus;
		}
		public void setTkStatus(Long tkStatus) {
			this.tkStatus = tkStatus;
		}
		public String getTkTotalRate() {
			return this.tkTotalRate;
		}
		public void setTkTotalRate(String tkTotalRate) {
			this.tkTotalRate = tkTotalRate;
		}
		public String getTotalCommissionFee() {
			return this.totalCommissionFee;
		}
		public void setTotalCommissionFee(String totalCommissionFee) {
			this.totalCommissionFee = totalCommissionFee;
		}
		public String getTotalCommissionRate() {
			return this.totalCommissionRate;
		}
		public void setTotalCommissionRate(String totalCommissionRate) {
			this.totalCommissionRate = totalCommissionRate;
		}
		public String getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(String tradeId) {
			this.tradeId = tradeId;
		}
		public String getTradeParentId() {
			return this.tradeParentId;
		}
		public void setTradeParentId(String tradeParentId) {
			this.tradeParentId = tradeParentId;
		}
		public String getUnid() {
			return this.unid;
		}
		public void setUnid(String unid) {
			this.unid = unid;
		}

}

	/**
 * PublisherOrderDto
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderPage extends TaobaoObject {

	private static final long serialVersionUID = 4637981491689343661L;

	/**
		 * 是否还有下一页
		 */
		@ApiField("has_next")
		private Boolean hasNext;
		/**
		 * 是否还有上一页
		 */
		@ApiField("has_pre")
		private Boolean hasPre;
		/**
		 * 页码
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 位点字段，由调用方原样传递
		 */
		@ApiField("position_index")
		private String positionIndex;
		/**
		 * PublisherOrderDto
		 */
		@ApiListField("results")
		@ApiField("publisher_order_dto")
		private List<PublisherOrderDto> results;
	

	public Boolean getHasNext() {
			return this.hasNext;
		}
		public void setHasNext(Boolean hasNext) {
			this.hasNext = hasNext;
		}
		public Boolean getHasPre() {
			return this.hasPre;
		}
		public void setHasPre(Boolean hasPre) {
			this.hasPre = hasPre;
		}
		public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public String getPositionIndex() {
			return this.positionIndex;
		}
		public void setPositionIndex(String positionIndex) {
			this.positionIndex = positionIndex;
		}
		public List<PublisherOrderDto> getResults() {
			return this.results;
		}
		public void setResults(List<PublisherOrderDto> results) {
			this.results = results;
		}

}



}
