/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.OpenAccountListResponse;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenAccountListRequest
extends BaseTaobaoRequest<OpenAccountListResponse> {
    private String isvAccountIds;
    private String openAccountIds;

    public void setIsvAccountIds(String isvAccountIds) {
        this.isvAccountIds = isvAccountIds;
    }

    public String getIsvAccountIds() {
        return this.isvAccountIds;
    }

    public void setOpenAccountIds(String openAccountIds) {
        this.openAccountIds = openAccountIds;
    }

    public String getOpenAccountIds() {
        return this.openAccountIds;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.open.account.list";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("isv_account_ids", this.isvAccountIds);
        txtParams.put("open_account_ids", this.openAccountIds);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<OpenAccountListResponse> getResponseClass() {
        return OpenAccountListResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkMaxListSize(this.isvAccountIds, 20, "isvAccountIds");
        RequestCheckUtils.checkMaxListSize(this.openAccountIds, 20, "openAccountIds");
    }
}

