/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.BaseMavenPublishPlugin;
import com.vanniktech.maven.publish.Configurer;
import com.vanniktech.maven.publish.MavenPublishConfigurer;
import com.vanniktech.maven.publish.MavenPublishPluginExtension;
import com.vanniktech.maven.publish.MavenPublishPom;
import com.vanniktech.maven.publish.MavenPublishTarget;
import com.vanniktech.maven.publish.UploadArchivesConfigurer;
import com.vanniktech.maven.publish.nexus.NexusConfigurer;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dokka.gradle.DokkaTask;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH$J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/vanniktech/maven/publish/BaseMavenPublishPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "p", "configureDokka", "project", "configureJavadoc", "configureMavenDeployer", "upload", "Lorg/gradle/api/tasks/Upload;", "target", "Lcom/vanniktech/maven/publish/MavenPublishTarget;", "configureSigning", "Companion", "gradle-maven-publish-plugin"})
public abstract class BaseMavenPublishPlugin
implements Plugin<Project> {
    public static final int MINIMUM_GRADLE_MAJOR = 4;
    public static final int MINIMUM_GRADLE_MINOR = 10;
    public static final int MINIMUM_GRADLE_MICRO = 1;
    @NotNull
    public static final String PLUGIN_DOKKA = "org.jetbrains.dokka";
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        MavenPublishPluginExtension extension = (MavenPublishPluginExtension)p.getExtensions().create("mavenPublish", MavenPublishPluginExtension.class, new Object[]{p});
        Gradle gradle = p.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"p.gradle");
        VersionNumber gradleVersion = VersionNumber.parse((String)gradle.getGradleVersion());
        if (gradleVersion.compareTo(new VersionNumber(4, 10, 1, null)) < 0) {
            throw (Throwable)new IllegalArgumentException("You need gradle version 4.10.1 or higher");
        }
        MavenPublishPom pom = MavenPublishPom.Companion.fromProject(p);
        p.setGroup((Object)pom.getGroupId());
        p.setVersion((Object)pom.getVersion());
        this.configureSigning(p);
        this.configureJavadoc(p);
        this.configureDokka(p);
        p.afterEvaluate((Action)new Action<Project>(this, extension){
            final /* synthetic */ BaseMavenPublishPlugin this$0;
            final /* synthetic */ MavenPublishPluginExtension $extension;

            public final void execute(Project project) {
                Configurer configurer2;
                if (this.$extension.getUseLegacyMode()) {
                    Project project2 = project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                    configurer2 = new UploadArchivesConfigurer(project2, (Function3<? super Upload, ? super Project, ? super MavenPublishTarget, Unit>)((Function3)new Function3<Upload, Project, MavenPublishTarget, Unit>(this.this$0){

                        public final void invoke(@NotNull Upload p1, @NotNull Project p2, @NotNull MavenPublishTarget p3) {
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                            Intrinsics.checkParameterIsNotNull((Object)p3, (String)"p3");
                            ((BaseMavenPublishPlugin)this.receiver).configureMavenDeployer(p1, p2, p3);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(BaseMavenPublishPlugin.class);
                        }

                        public final String getName() {
                            return "configureMavenDeployer";
                        }

                        public final String getSignature() {
                            return "configureMavenDeployer(Lorg/gradle/api/tasks/Upload;Lorg/gradle/api/Project;Lcom/vanniktech/maven/publish/MavenPublishTarget;)V";
                        }
                    }));
                } else {
                    Project project3 = project;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                    configurer2 = new MavenPublishConfigurer(project3, (Iterable)this.$extension.getTargets());
                }
                Configurer configurer3 = configurer2;
                this.$extension.getTargets().all((Action)new Action<MavenPublishTarget>(configurer3){
                    final /* synthetic */ Configurer $configurer;

                    public final void execute(MavenPublishTarget it) {
                        String string = it.getReleaseRepositoryUrl();
                        boolean bl = false;
                        boolean bl2 = false;
                        if (string == null) {
                            boolean bl3 = false;
                            String string2 = "releaseRepositoryUrl of " + it.getName$gradle_maven_publish_plugin() + " is required to be set";
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        MavenPublishTarget mavenPublishTarget = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)mavenPublishTarget, (String)"it");
                        this.$configurer.configureTarget(mavenPublishTarget);
                    }
                    {
                        this.$configurer = configurer2;
                    }
                });
                if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
                    configurer3.configureKotlinMppProject();
                } else if (project.getPlugins().hasPlugin("com.android.library")) {
                    configurer3.configureAndroidArtifacts();
                } else {
                    configurer3.configureJavaArtifacts();
                }
                new NexusConfigurer(project);
            }
            {
                this.this$0 = baseMavenPublishPlugin;
                this.$extension = mavenPublishPluginExtension;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void configureSigning(Project project) {
        void $this$isSigningRequired$iv;
        project.getPlugins().apply(SigningPlugin.class);
        Project $this$signing$iv = project;
        boolean $i$f$getSigning = false;
        Object object = $this$signing$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
        $this$signing$iv = project;
        SigningExtension signingExtension = (SigningExtension)object;
        boolean $i$f$isSigningRequired = false;
        Callable callable = new Callable<Boolean>((Project)$this$isSigningRequired$iv){
            final /* synthetic */ Project $this_isSigningRequired;

            public final boolean call() {
                Project project = this.$this_isSigningRequired.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                return !StringsKt.contains$default((CharSequence)project.getVersion().toString(), (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null);
            }
            {
                this.$this_isSigningRequired = project;
            }
        };
        signingExtension.setRequired((Object)callable);
    }

    private final void configureJavadoc(Project project) {
        project.getTasks().withType(Javadoc.class).configureEach((Action)configureJavadoc.1.INSTANCE);
    }

    private final void configureDokka(Project project) {
        project.getPlugins().withId("org.jetbrains.kotlin.jvm", (Action)new Action<Plugin<Object>>(project){
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                this.$project.getPlugins().apply("org.jetbrains.dokka");
            }
            {
                this.$project = project;
            }
        });
        project.getPlugins().withId("org.jetbrains.kotlin.android", (Action)new Action<Plugin<Object>>(project){
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                this.$project.getPlugins().apply("org.jetbrains.dokka");
            }
            {
                this.$project = project;
            }
        });
        project.getPlugins().withId("org.jetbrains.kotlin.multiplatform", (Action)configureDokka.3.INSTANCE);
        project.getPlugins().withId(PLUGIN_DOKKA, (Action)new Action<Plugin<Object>>(project){
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                this.$project.getTasks().withType(DokkaTask.class).configureEach((Action)new Action<DokkaTask>(this){
                    final /* synthetic */ configureDokka.4 this$0;

                    public final void execute(DokkaTask it) {
                        CharSequence charSequence = it.getOutputDirectory();
                        boolean bl = false;
                        if (charSequence.length() == 0) {
                            JavaPluginConvention javaConvention;
                            JavaPluginConvention javaPluginConvention = javaConvention = (JavaPluginConvention)this.this$0.$project.getConvention().getPlugin(JavaPluginConvention.class);
                            Intrinsics.checkExpressionValueIsNotNull((Object)javaPluginConvention, (String)"javaConvention");
                            File file = javaPluginConvention.getDocsDir();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"javaConvention.docsDir");
                            File file2 = FilesKt.resolve((File)file, (String)"dokka");
                            File file3 = this.this$0.$project.getProjectDir();
                            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"project.projectDir");
                            it.setOutputDirectory(FilesKt.toRelativeString((File)file2, (File)file3));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$project = project;
            }
        });
    }

    protected abstract void configureMavenDeployer(@NotNull Upload var1, @NotNull Project var2, @NotNull MavenPublishTarget var3);

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vanniktech/maven/publish/BaseMavenPublishPlugin$Companion;", "", "()V", "MINIMUM_GRADLE_MAJOR", "", "MINIMUM_GRADLE_MICRO", "MINIMUM_GRADLE_MINOR", "PLUGIN_DOKKA", "", "gradle-maven-publish-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

