/*
 * Decompiled with CFR 0.152.
 */
package com.vivo.push.sdk.notofication;

import com.vivo.push.sdk.server.Validation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Message
implements Serializable {
    private final String regId;
    private final String alias;
    private final int notifyType;
    private final String title;
    private final String content;
    private final int timeToLive;
    private final int skipType;
    private final String skipContent;
    private final int networkType;
    private Map<String, String> clientCustomMap;
    private final Map<String, String> extra;
    private final String requestId;
    private final Map<String, List<String>> tagExpression;

    protected Message(Builder builder) {
        this.regId = builder.regId;
        this.alias = builder.alias;
        this.notifyType = builder.notifyType;
        this.title = builder.title;
        this.content = builder.content;
        this.timeToLive = builder.timeToLive;
        this.skipType = builder.skipType;
        this.skipContent = builder.skipContent;
        this.networkType = builder.networkType;
        this.extra = builder.extra;
        this.clientCustomMap = builder.clientCustomMap;
        this.requestId = builder.requestId;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (builder.orTags != null) {
            map.put("orTags", builder.orTags);
        } else {
            map.put("orTags", new ArrayList());
        }
        if (builder.andTags != null) {
            map.put("andTags", builder.andTags);
        } else {
            map.put("andTags", new ArrayList());
        }
        if (builder.notTags != null) {
            map.put("notTags", builder.notTags);
        } else {
            map.put("notTags", new ArrayList());
        }
        this.tagExpression = map;
    }

    public String getRegId() {
        return this.regId;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getNotifyType() {
        return this.notifyType;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public int getSkipType() {
        return this.skipType;
    }

    public String getSkipContent() {
        return this.skipContent;
    }

    public int getNetworkType() {
        return this.networkType;
    }

    public Map<String, String> getClientCustomMap() {
        return this.clientCustomMap;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Map<String, List<String>> getTagExpression() {
        return this.tagExpression;
    }

    public static final class Builder {
        private String regId;
        private String alias;
        private int notifyType;
        private String title;
        private String content;
        private int timeToLive;
        private int skipType;
        private String skipContent;
        private int networkType = -1;
        private Map<String, String> clientCustomMap = new LinkedHashMap<String, String>();
        private Map<String, String> extra = new LinkedHashMap<String, String>();
        private String requestId;
        private List<String> orTags;
        private List<String> andTags;
        private List<String> notTags;

        public Builder regId(String value) {
            this.regId = value;
            return this;
        }

        public Builder alias(String value) {
            this.alias = value;
            return this;
        }

        public Builder notifyType(int value) {
            this.notifyType = value;
            return this;
        }

        public Builder title(String value) {
            this.title = value = value.trim();
            return this;
        }

        public Builder content(String value) {
            this.content = value = value.trim();
            return this;
        }

        public Builder timeToLive(int value) {
            this.timeToLive = value;
            return this;
        }

        public Builder skipType(int value) {
            this.skipType = value;
            return this;
        }

        public Builder skipContent(String value) {
            this.skipContent = value = value.trim();
            return this;
        }

        public Builder networkType(int value) {
            this.networkType = value;
            return this;
        }

        public Builder clientCustomMap(Map<String, String> map) {
            this.clientCustomMap = map;
            return this;
        }

        public Builder extra(String callback, String param) {
            this.extra.put("callback", callback);
            this.extra.put("callback.param", param);
            return this;
        }

        public Builder requestId(String value) {
            this.requestId = value = value.trim();
            return this;
        }

        public Builder orTags(List<String> orTags) {
            this.orTags = orTags;
            return this;
        }

        public Builder andTags(List<String> andTags) {
            this.andTags = andTags;
            return this;
        }

        public Builder notTags(List<String> notTags) {
            this.notTags = notTags;
            return this;
        }

        public Message build() {
            Message message = new Message(this);
            Validation.validatePublicMessage(message);
            return message;
        }
    }
}

