/*
 * Decompiled with CFR 0.152.
 */
package com.vivo.push.sdk.notofication;

import com.vivo.push.sdk.server.Validation;
import java.io.Serializable;
import java.util.Set;

public class TargetMessage
implements Serializable {
    private final Set<String> regIds;
    private final Set<String> aliases;
    private final String taskId;
    private final String requestId;

    protected TargetMessage(Builder builder) {
        this.regIds = builder.regIds;
        this.aliases = builder.aliases;
        this.taskId = builder.taskId;
        this.requestId = builder.requestId;
    }

    public Set<String> getRegIds() {
        return this.regIds;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public static final class Builder {
        private Set<String> regIds;
        private Set<String> aliases;
        private String taskId;
        private String requestId;

        public Builder regIds(Set<String> regIds) {
            this.regIds = regIds;
            return this;
        }

        public Builder aliases(Set<String> aliases) {
            this.aliases = aliases;
            return this;
        }

        public Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public TargetMessage build() {
            TargetMessage targetMessage = new TargetMessage(this);
            Validation.validateTargetMessage(targetMessage);
            return targetMessage;
        }
    }
}

