/*
 * Decompiled with CFR 0.152.
 */
package com.vivo.push.sdk.server;

import com.alibaba.fastjson.JSON;
import com.vivo.push.sdk.common.HttpUtil;
import com.vivo.push.sdk.common.SignUtils;
import com.vivo.push.sdk.notofication.Message;
import com.vivo.push.sdk.notofication.Result;
import com.vivo.push.sdk.notofication.TargetMessage;
import com.vivo.push.sdk.server.Validation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class Sender
extends HttpUtil {
    public Sender(String secret) throws Exception {
        super(Validation.nonNull(secret));
        Sender.init();
    }

    public void initPool(int connection, int route) throws Exception {
        Sender.init(connection, route);
    }

    public Result getToken(int appId, String appKey) throws Exception {
        Result result = null;
        result = this.setTokenBody(appId, appKey);
        return result;
    }

    public Result sendSingle(Message singleMessage) throws Exception {
        Validation.validateSingleMessage(singleMessage);
        Result result = null;
        result = Sender.sendMessage(this.doPost(this.toJsonString(singleMessage), "/message/send"));
        return result;
    }

    public Result saveListPayLoad(Message listPayLoad) throws Exception {
        Validation.validateLiveTime(listPayLoad);
        Result result = null;
        result = Sender.sendMessage(this.doPost(this.toJsonString(listPayLoad), "/message/saveListPayload"));
        return result;
    }

    public Result sendToList(TargetMessage targetMessage) throws Exception {
        Result result = null;
        String jsonBody = JSON.toJSONString((Object)targetMessage);
        result = Sender.sendMessage(this.doPost(jsonBody, "/message/pushToList"));
        return result;
    }

    public Result sendToAll(Message allMessage) throws Exception {
        Validation.validateLiveTime(allMessage);
        Result result = null;
        result = Sender.sendMessage(this.doPost(this.toJsonString(allMessage), "/message/all"));
        return result;
    }

    public Result sendToTag(Message tagMessage) throws Exception {
        Validation.validateTagExpression(tagMessage.getTagExpression());
        Result result = null;
        result = Sender.sendMessage(this.doPost(this.toJsonString(tagMessage), "/message/tagPush"));
        return result;
    }

    public Result getStatistics(Set<String> taskIds) throws Exception {
        Validation.validateTaskIds(taskIds);
        Result result = null;
        result = Sender.sendMessage(this.doGet(this.toUrl("/report/getStatistics", taskIds)));
        return result;
    }

    private String toUrl(String requestPath, Set<String> taskId) throws IOException {
        StringBuilder builder = new StringBuilder(requestPath).append("?taskIds=");
        Iterator<String> iterator = taskId.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next()).append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private String toJsonString(Message message) throws IOException {
        String jsonBody = JSON.toJSONString((Object)message);
        return jsonBody;
    }

    private Result setTokenBody(int appId, String appKey) throws Exception {
        HashMap<String, Object> body = new HashMap<String, Object>(4);
        long timestamp = System.currentTimeMillis();
        body.put("appId", appId);
        body.put("appKey", appKey);
        body.put("timestamp", timestamp);
        body.put("sign", SignUtils.getSign(appId, appKey, timestamp, this.secret));
        String jsonBody = JSON.toJSONString(body);
        Result result = Sender.sendMessage(this.doPost(jsonBody, "/message/auth"));
        return result;
    }
}

