/*
 * Decompiled with CFR 0.152.
 */
package com.vivo.push.sdk.server;

import com.alibaba.fastjson.JSON;
import com.vivo.push.sdk.common.HttpUtil;
import com.vivo.push.sdk.notofication.Result;
import com.vivo.push.sdk.server.Validation;
import com.vivo.push.sdk.tag.TagMessage;

public class TagManage
extends HttpUtil {
    public TagManage(String secret) throws Exception {
        super(Validation.nonNull(secret));
        TagManage.init();
    }

    public void initPool(int connection, int route) throws Exception {
        TagManage.init(connection, route);
    }

    public Result addTag(TagMessage tagMessage) throws Exception {
        Result result = null;
        Validation.validateTagName(tagMessage.getName());
        result = TagManage.sendMessage(this.doPost(JSON.toJSONString((Object)tagMessage), "/tag/add"));
        return result;
    }

    public Result updateTag(TagMessage updateMessage) throws Exception {
        Result result = null;
        Validation.validateTagName(updateMessage.getOldName());
        Validation.validateTagName(updateMessage.getNewName());
        result = TagManage.sendMessage(this.doPost(JSON.toJSONString((Object)updateMessage), "/tag/update"));
        return result;
    }

    public Result addMembers(TagMessage membersMessage) throws Exception {
        Result result = null;
        Validation.validateTagMember(membersMessage);
        result = TagManage.sendMessage(this.doPost(JSON.toJSONString((Object)membersMessage), "/tag/addMembers"));
        return result;
    }

    public Result removeMembers(TagMessage membersMessage) throws Exception {
        Result result = null;
        Validation.validateTagMember(membersMessage);
        result = TagManage.sendMessage(this.doPost(JSON.toJSONString((Object)membersMessage), "/tag/removeMembers"));
        return result;
    }
}

