/*
 * Decompiled with CFR 0.152.
 */
package com.vivo.push.sdk.server;

import com.alibaba.fastjson.JSON;
import com.vivo.push.sdk.common.HttpUtil;
import com.vivo.push.sdk.notofication.Result;
import com.vivo.push.sdk.server.Validation;
import com.vivo.push.sdk.tag.TagSegMessage;

public class TagSegment
extends HttpUtil {
    public TagSegment(String secret) throws Exception {
        super(Validation.nonNull(secret));
        TagSegment.init();
    }

    public void initPool(int connection, int route) throws Exception {
        TagSegment.init(connection, route);
    }

    public Result addTagSegment(TagSegMessage tagSegMessage) throws Exception {
        Result result = null;
        Validation.validateTagName(tagSegMessage.getName());
        Validation.validateTagExpression(tagSegMessage.getExpression());
        result = TagSegment.sendMessage(this.doPost(JSON.toJSONString((Object)tagSegMessage), "/tagSegment/add"));
        return result;
    }

    public Result updateTagSegment(TagSegMessage updateMessage) throws Exception {
        Result result = null;
        Validation.validateTagName(updateMessage.getOldName());
        Validation.validateTagName(updateMessage.getNewName());
        if (updateMessage.getExpression() != null) {
            Validation.validateTagExpression(updateMessage.getExpression());
        }
        result = TagSegment.sendMessage(this.doPost(JSON.toJSONString((Object)updateMessage), "/tagSegment/update"));
        return result;
    }
}

