/*
 * Decompiled with CFR 0.152.
 */
package com.vivo.push.sdk.tag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagSegMessage {
    private final String name;
    private final String oldName;
    private final String newName;
    private final Map<String, List<String>> expression;

    protected TagSegMessage(Builder builder) {
        this.name = builder.name;
        this.oldName = builder.oldName;
        this.newName = builder.newName;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (builder.orTags != null) {
            map.put("orTags", builder.orTags);
        } else {
            map.put("orTags", new ArrayList());
        }
        if (builder.andTags != null) {
            map.put("andTags", builder.andTags);
        } else {
            map.put("andTags", new ArrayList());
        }
        if (builder.notTags != null) {
            map.put("notTags", builder.notTags);
        } else {
            map.put("notTags", new ArrayList());
        }
        this.expression = map;
    }

    public String getName() {
        return this.name;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public Map<String, List<String>> getExpression() {
        return this.expression;
    }

    public static final class Builder {
        private String name;
        private String oldName;
        private String newName;
        private List<String> orTags;
        private List<String> andTags;
        private List<String> notTags;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder oldName(String oldName) {
            this.oldName = oldName;
            return this;
        }

        public Builder newName(String newName) {
            this.newName = newName;
            return this;
        }

        public Builder orTags(List<String> orTags) {
            this.orTags = orTags;
            return this;
        }

        public Builder andTags(List<String> andTags) {
            this.andTags = andTags;
            return this;
        }

        public Builder notTags(List<String> notTags) {
            this.notTags = notTags;
            return this;
        }

        public TagSegMessage build() {
            TagSegMessage TagSegMessage2 = new TagSegMessage(this);
            return TagSegMessage2;
        }
    }
}

