/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.graph;

import de.flapdoodle.graph.Edge;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Edge", generator="Immutables")
public final class ImmutableEdge<V, E>
implements Edge<V, E> {
    private final V start;
    private final V end;
    private final E edge;

    private ImmutableEdge(V start, V end, E edge) {
        this.start = Objects.requireNonNull(start, "start");
        this.end = Objects.requireNonNull(end, "end");
        this.edge = Objects.requireNonNull(edge, "edge");
    }

    private ImmutableEdge(ImmutableEdge<V, E> original, V start, V end, E edge) {
        this.start = start;
        this.end = end;
        this.edge = edge;
    }

    @Override
    public V start() {
        return this.start;
    }

    @Override
    public V end() {
        return this.end;
    }

    @Override
    public E edge() {
        return this.edge;
    }

    public final ImmutableEdge<V, E> withStart(V value) {
        if (this.start == value) {
            return this;
        }
        V newValue = Objects.requireNonNull(value, "start");
        return new ImmutableEdge<V, E>(this, newValue, this.end, this.edge);
    }

    public final ImmutableEdge<V, E> withEnd(V value) {
        if (this.end == value) {
            return this;
        }
        V newValue = Objects.requireNonNull(value, "end");
        return new ImmutableEdge<V, E>(this, this.start, newValue, this.edge);
    }

    public final ImmutableEdge<V, E> withEdge(E value) {
        if (this.edge == value) {
            return this;
        }
        E newValue = Objects.requireNonNull(value, "edge");
        return new ImmutableEdge<V, E>(this, this.start, this.end, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEdge && this.equalTo(0, (ImmutableEdge)another);
    }

    private boolean equalTo(int synthetic, ImmutableEdge<?, ?> another) {
        return this.start.equals(another.start) && this.end.equals(another.end) && this.edge.equals(another.edge);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.start.hashCode();
        h += (h << 5) + this.end.hashCode();
        h += (h << 5) + this.edge.hashCode();
        return h;
    }

    public String toString() {
        return "Edge{start=" + this.start + ", end=" + this.end + ", edge=" + this.edge + "}";
    }

    public static <V, E> ImmutableEdge<V, E> of(V start, V end, E edge) {
        return new ImmutableEdge<V, E>(start, end, edge);
    }

    public static <V, E> ImmutableEdge<V, E> copyOf(Edge<V, E> instance) {
        if (instance instanceof ImmutableEdge) {
            return (ImmutableEdge)instance;
        }
        return ImmutableEdge.builder().from(instance).build();
    }

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    @Generated(from="Edge", generator="Immutables")
    public static final class Builder<V, E> {
        private static final long INIT_BIT_START = 1L;
        private static final long INIT_BIT_END = 2L;
        private static final long INIT_BIT_EDGE = 4L;
        private long initBits = 7L;
        private V start;
        private V end;
        private E edge;

        private Builder() {
        }

        public final Builder<V, E> from(Edge<V, E> instance) {
            Objects.requireNonNull(instance, "instance");
            this.start(instance.start());
            this.end(instance.end());
            this.edge(instance.edge());
            return this;
        }

        public final Builder<V, E> start(V start) {
            this.start = Objects.requireNonNull(start, "start");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<V, E> end(V end) {
            this.end = Objects.requireNonNull(end, "end");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<V, E> edge(E edge) {
            this.edge = Objects.requireNonNull(edge, "edge");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableEdge<V, E> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEdge(null, this.start, this.end, this.edge);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("start");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("end");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("edge");
            }
            return "Cannot build Edge, some of required attributes are not set " + attributes;
        }
    }
}

