/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.reverse.StateID;
import java.util.Set;

public interface StateLookup {
    public <D> D of(StateID<D> var1);

    default public StateLookup limitedTo(Set<StateID<?>> allowedStates) {
        return StateLookup.limitedTo(allowedStates, this);
    }

    public static StateLookup limitedTo(final Set<StateID<?>> allowedStates, final StateLookup delegate) {
        return new StateLookup(){

            @Override
            public <D> D of(StateID<D> type) {
                Preconditions.checkArgument((boolean)allowedStates.contains(type), (String)"stateID not allowed: %s", (Object[])new Object[]{type});
                return delegate.of(type);
            }
        };
    }
}

