/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.graph.GraphAsDot;
import de.flapdoodle.graph.Graphs;
import de.flapdoodle.graph.ImmutableSubGraph;
import de.flapdoodle.graph.VerticesAndEdges;
import de.flapdoodle.reverse.ImmutableMappedWrapper;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.MapBasedStateLookup;
import de.flapdoodle.reverse.NamedTypeAndState;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.TearDownException;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.TransitionMapping;
import de.flapdoodle.reverse.Transitions;
import de.flapdoodle.reverse.graph.HasSubGraph;
import de.flapdoodle.reverse.graph.StateVertex;
import de.flapdoodle.reverse.graph.TransitionGraph;
import de.flapdoodle.reverse.graph.TransitionVertex;
import de.flapdoodle.reverse.graph.Vertex;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class TransitionWalker {
    private final DefaultDirectedGraph<Vertex, DefaultEdge> graph;

    private TransitionWalker(DefaultDirectedGraph<Vertex, DefaultEdge> graph) {
        this.graph = graph;
    }

    private static Map<StateID<?>, State<?>> resolve(List<Transition<?>> transitions, Set<StateID<?>> destinations, StateLookup stateOfType, List<Listener> initListener) {
        LinkedHashMap ret = new LinkedHashMap();
        for (Transition<?> transition : transitions) {
            if (!destinations.contains(transition.destination())) continue;
            State<?> newState = TransitionWalker.resolve(stateOfType, initListener, transition);
            ret.put(transition.destination(), newState);
        }
        return ret;
    }

    private static <T> State<T> resolve(StateLookup stateOfType, List<Listener> initListener, Transition<T> transition) {
        StateLookup lookup = stateOfType.limitedTo(transition.sources());
        State state = transition instanceof MappedWrapper ? ((MappedWrapper)transition).result(lookup, initListener) : transition.result(lookup);
        initListener.forEach(listener -> listener.onStateReached(transition.destination(), state.value()));
        return state;
    }

    public <D> ReachedState<D> initState(StateID<D> destination, Listener ... listener) {
        return this.initState(destination, Arrays.asList(listener));
    }

    public <D> ReachedState<D> initState(StateID<D> destination, Collection<Listener> listener) {
        return this.initState(new LinkedHashMap(), destination, new ArrayList<Listener>(listener));
    }

    public <D> Transition<D> asTransitionTo(TransitionMapping<D> mapping) {
        StateVertex destination = StateVertex.of(mapping.destination().source());
        Preconditions.checkArgument((boolean)this.graph.containsVertex((Object)destination), (String)"state %s is not part of this init process", (Object[])new Object[]{TransitionGraph.asMessage(mapping.destination().source())});
        Collection<VerticesAndEdges<Vertex, DefaultEdge>> dependencies = TransitionWalker.dependenciesOf(this.graph, destination);
        Set<StateID<?>> sources = TransitionWalker.missingSources(dependencies, new LinkedHashMap());
        return ImmutableMappedWrapper.builder().graph(this.graph).transitionLabel(mapping.label()).transitionMapping(mapping).addAllMissingSources(sources).build();
    }

    private <D> ReachedState<D> initState(Map<StateID<?>, State<?>> currentStateMap, StateID<D> dest, List<Listener> initListener) {
        Preconditions.checkArgument((!currentStateMap.containsKey(dest) ? 1 : 0) != 0, (String)"state %s already initialized", (Object[])new Object[]{TransitionGraph.asMessage(dest)});
        StateVertex destination = StateVertex.of(dest);
        Preconditions.checkArgument((boolean)this.graph.containsVertex((Object)destination), (String)"state %s is not part of this init process", (Object[])new Object[]{TransitionGraph.asMessage(dest)});
        LinkedHashMap stateMap = new LinkedHashMap(currentStateMap);
        ArrayList initializedStates = new ArrayList();
        Collection<VerticesAndEdges<Vertex, DefaultEdge>> dependencies = TransitionWalker.dependenciesOf(this.graph, destination);
        if (!dependencies.isEmpty()) {
            Set<StateID<?>> missingSources = TransitionWalker.missingSources(dependencies, currentStateMap);
            Preconditions.checkArgument((boolean)missingSources.isEmpty(), (String)"missing transitions: %s", (Object[])new Object[]{TransitionGraph.asMessage(missingSources)});
        }
        for (VerticesAndEdges<Vertex, DefaultEdge> set : dependencies) {
            List<Transition<?>> transitions = set.vertices().stream().filter(it -> it instanceof TransitionVertex).map(it -> (TransitionVertex)it).map(TransitionVertex::transition).collect(Collectors.toList());
            Set destinations = transitions.stream().map(Transition::destination).collect(Collectors.toSet());
            Set<StateID<?>> needInitialization = TransitionWalker.filterNotIn(stateMap.keySet(), destinations);
            try {
                Map<StateID<?>, State<?>> newStatesAsMap = TransitionWalker.resolve(transitions, needInitialization, new MapBasedStateLookup(stateMap), initListener);
                if (newStatesAsMap.isEmpty()) continue;
                initializedStates.add(TransitionWalker.asNamedTypeAndState(newStatesAsMap));
                stateMap.putAll(newStatesAsMap);
            }
            catch (RuntimeException ex) {
                TransitionWalker.tearDown(initializedStates, initListener, Optional.of(new RuntimeException("rollback after error on transition to " + TransitionGraph.asMessage(needInitialization) + ", successful reached:" + TransitionWalker.successStatesAsMessage(initializedStates), ex)));
            }
        }
        return new ReachedState(this, initializedStates, stateMap, TransitionWalker.stateOfMap(stateMap, dest), initListener);
    }

    private static Set<StateID<?>> missingSources(Collection<VerticesAndEdges<Vertex, DefaultEdge>> dependencies, Map<StateID<?>, State<?>> currentStateMap) {
        return dependencies.stream().findFirst().map(VerticesAndEdges::vertices).orElse(Collections.emptySet()).stream().filter(it -> it instanceof StateVertex).map(it -> ((StateVertex)it).stateId()).filter(it -> !currentStateMap.containsKey(it)).collect(Collectors.toSet());
    }

    private static Collection<VerticesAndEdges<Vertex, DefaultEdge>> dependenciesOf(DefaultDirectedGraph<Vertex, DefaultEdge> routesAsGraph, StateVertex destination) {
        DefaultDirectedGraph filtered = Graphs.filter(routesAsGraph, v -> v.equals(destination) || TransitionWalker.isDependencyOf(routesAsGraph, v, destination));
        return Graphs.rootsOf((DefaultDirectedGraph)filtered);
    }

    private static boolean isDependencyOf(DefaultDirectedGraph<Vertex, DefaultEdge> routesAsGraph, Vertex source, StateVertex destination) {
        GraphPath ret = DijkstraShortestPath.findPathBetween(routesAsGraph, (Object)source, (Object)destination);
        return ret != null && !ret.getEdgeList().isEmpty();
    }

    private static <D> State<D> stateOfMap(Map<StateID<?>, State<?>> stateMap, StateID<D> destination) {
        return stateMap.get(destination);
    }

    private static void tearDown(List<Collection<NamedTypeAndState<?>>> initializedStates, List<Listener> initListener, Optional<RuntimeException> optCause) {
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        ArrayList copy = new ArrayList(initializedStates);
        Collections.reverse(copy);
        copy.forEach((Consumer<Collection<NamedTypeAndState<?>>>)((Consumer<Collection>)stateSet -> stateSet.forEach(typeAndState -> {
            TransitionWalker.notifyListener(initListener, typeAndState);
            try {
                State.tearDown(typeAndState.state());
            }
            catch (RuntimeException rx) {
                exceptions.add(rx);
            }
        })));
        TearDownException tearDownException = null;
        if (!exceptions.isEmpty()) {
            tearDownException = exceptions.size() == 1 ? new TearDownException("tearDown errors", (RuntimeException)exceptions.get(0)) : new TearDownException("tearDown errors", exceptions);
        }
        if (optCause.isPresent()) {
            RuntimeException cause = optCause.get();
            if (tearDownException != null) {
                cause.addSuppressed(tearDownException);
            }
            throw cause;
        }
        if (tearDownException != null) {
            throw tearDownException;
        }
    }

    private static Collection<NamedTypeAndState<?>> asNamedTypeAndState(Map<StateID<?>, State<?>> newStatesAsMap) {
        return newStatesAsMap.entrySet().stream().map(TransitionWalker::namedTypeAndStateOf).collect(Collectors.toList());
    }

    private static NamedTypeAndState<?> namedTypeAndStateOf(Map.Entry<StateID<?>, State<?>> e) {
        return NamedTypeAndState.of(e.getKey(), e.getValue());
    }

    private static <T> void notifyListener(List<Listener> initListener, NamedTypeAndState<T> typeAndState) {
        initListener.forEach(listener -> listener.onStateTearDown(typeAndState.type(), typeAndState.state().value()));
    }

    private static <T> Set<T> filterNotIn(Set<T> existing, Set<T> toFilter) {
        return toFilter.stream().filter(t -> !existing.contains(t)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static TransitionWalker with(List<? extends Transition<?>> src) {
        ArrayList routes = new ArrayList(src);
        Transitions.assertNoCollisions(routes);
        DefaultDirectedGraph<Vertex, DefaultEdge> graph = TransitionGraph.asGraph(routes);
        List loops = Graphs.loopsOf(graph);
        Preconditions.checkArgument((boolean)loops.isEmpty(), (String)"loops are not supported: %s", (Object[])new Object[]{Preconditions.lazy(() -> TransitionGraph.asMessage(loops))});
        return new TransitionWalker(graph);
    }

    private static String successStatesAsMessage(List<Collection<NamedTypeAndState<?>>> initializedStates) {
        ArrayList copy = new ArrayList(initializedStates);
        Collections.reverse(copy);
        return copy.stream().flatMap(Collection::stream).map(it -> "  " + TransitionGraph.asMessage(it.type()) + "=" + it.state().value()).collect(Collectors.joining(",\n", "\n", "\n"));
    }

    public static class ReachedState<D>
    implements AutoCloseable {
        private final State<D> state;
        private final List<Collection<NamedTypeAndState<?>>> initializedStates;
        private final Map<StateID<?>, State<?>> stateMap;
        private final TransitionWalker parent;
        private final List<Listener> initListener;

        private ReachedState(TransitionWalker parent, List<Collection<NamedTypeAndState<?>>> initializedStates, Map<StateID<?>, State<?>> stateMap, State<D> state, List<Listener> initListener) {
            this.parent = parent;
            this.state = state;
            this.initListener = (List)Preconditions.checkNotNull(initListener, (String)"initListener is null", (Object[])new Object[0]);
            this.stateMap = new LinkedHashMap(stateMap);
            this.initializedStates = new ArrayList(initializedStates);
        }

        public <T> ReachedState<T> initState(StateID<T> destination) {
            return this.parent.initState(this.stateMap, destination, this.initListener);
        }

        @Override
        public void close() {
            TransitionWalker.tearDown(this.initializedStates, this.initListener, Optional.empty());
        }

        public D current() {
            return this.state.value();
        }

        public State<D> asState() {
            return State.builder(this.current()).onTearDown(current -> this.close()).build();
        }
    }

    @Value.Immutable
    static abstract class MappedWrapper<T>
    implements Transition<T>,
    HasLabel,
    HasSubGraph {
        MappedWrapper() {
        }

        protected abstract TransitionMapping<T> transitionMapping();

        protected abstract Set<StateID<?>> missingSources();

        protected abstract DefaultDirectedGraph<Vertex, DefaultEdge> graph();

        @Override
        public abstract String transitionLabel();

        @Override
        @Value.Lazy
        public StateID<T> destination() {
            return this.transitionMapping().destination().destination();
        }

        @Override
        @Value.Lazy
        public Set<StateID<?>> sources() {
            return this.missingSources().stream().map(this.transitionMapping()::sourceOf).collect(Collectors.toSet());
        }

        @Override
        @Value.Auxiliary
        public State<T> result(StateLookup lookup) {
            return this.result(lookup, Collections.emptyList());
        }

        @Value.Auxiliary
        protected State<T> result(StateLookup lookup, List<Listener> listener) {
            Map<StateID, State> stateMap = this.sources().stream().collect(Collectors.toMap(this.transitionMapping()::destinationOf, id -> State.of(lookup.of(id), new TearDown[0])));
            ReachedState reachedState = new TransitionWalker(this.graph()).initState(stateMap, this.transitionMapping().destination().source(), listener);
            return State.of(reachedState.current(), ignore -> reachedState.close());
        }

        @Override
        @Value.Lazy
        public ImmutableSubGraph<Vertex> subGraph() {
            return GraphAsDot.SubGraph.of(this.graph()).connections(MappedWrapper.asSubGraphMap(this.transitionMapping(), this.missingSources())).build();
        }

        private static Map<? extends Vertex, ? extends Vertex> asSubGraphMap(TransitionMapping<?> transitionMapping, Set<StateID<?>> missingSources) {
            LinkedHashMap<StateVertex, StateVertex> ret = new LinkedHashMap<StateVertex, StateVertex>();
            missingSources.forEach(dest -> {
                StateID source = transitionMapping.sourceOf(dest);
                ret.put(StateVertex.of(source), StateVertex.of(dest));
            });
            ret.put(StateVertex.of(transitionMapping.destination().destination()), StateVertex.of(transitionMapping.destination().source()));
            return Collections.unmodifiableMap(ret);
        }
    }
}

