// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/extensions/filters/http/jwt_authn/v3/config.proto

package io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3;

/**
 * <pre>
 * This is the Envoy HTTP filter config for JWT authentication.
 * For example:
 * .. code-block:: yaml
 *   providers:
 *      provider1:
 *        issuer: issuer1
 *        audiences:
 *        - audience1
 *        - audience2
 *        remote_jwks:
 *          http_uri:
 *            uri: https://example.com/.well-known/jwks.json
 *            cluster: example_jwks_cluster
 *      provider2:
 *        issuer: issuer2
 *        local_jwks:
 *          inline_string: jwks_string
 *   rules:
 *      # Not jwt verification is required for /health path
 *      - match:
 *          prefix: /health
 *      # Jwt verification for provider1 is required for path prefixed with "prefix"
 *      - match:
 *          prefix: /prefix
 *        requires:
 *          provider_name: provider1
 *      # Jwt verification for either provider1 or provider2 is required for all other requests.
 *      - match:
 *          prefix: /
 *        requires:
 *          requires_any:
 *            requirements:
 *              - provider_name: provider1
 *              - provider_name: provider2
 * </pre>
 *
 * Protobuf type {@code envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication}
 */
public  final class JwtAuthentication extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication)
    JwtAuthenticationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use JwtAuthentication.newBuilder() to construct.
  private JwtAuthentication(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private JwtAuthentication() {
    rules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new JwtAuthentication();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private JwtAuthentication(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              providers_ = com.google.protobuf.MapField.newMapField(
                  ProvidersDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000001;
            }
            com.google.protobuf.MapEntry<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider>
            providers__ = input.readMessage(
                ProvidersDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            providers_.getMutableMap().put(
                providers__.getKey(), providers__.getValue());
            break;
          }
          case 18: {
            if (!((mutable_bitField0_ & 0x00000002) != 0)) {
              rules_ = new java.util.ArrayList<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule>();
              mutable_bitField0_ |= 0x00000002;
            }
            rules_.add(
                input.readMessage(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.parser(), extensionRegistry));
            break;
          }
          case 26: {
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.Builder subBuilder = null;
            if (filterStateRules_ != null) {
              subBuilder = filterStateRules_.toBuilder();
            }
            filterStateRules_ = input.readMessage(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(filterStateRules_);
              filterStateRules_ = subBuilder.buildPartial();
            }

            break;
          }
          case 32: {

            bypassCorsPreflight_ = input.readBool();
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        rules_ = java.util.Collections.unmodifiableList(rules_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtAuthentication_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 1:
        return internalGetProviders();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtAuthentication_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.class, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.Builder.class);
  }

  public static final int PROVIDERS_FIELD_NUMBER = 1;
  private static final class ProvidersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider>newDefaultInstance(
                io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtAuthentication_ProvidersEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.MESSAGE,
                io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider.getDefaultInstance());
  }
  private com.google.protobuf.MapField<
      java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> providers_;
  private com.google.protobuf.MapField<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider>
  internalGetProviders() {
    if (providers_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ProvidersDefaultEntryHolder.defaultEntry);
    }
    return providers_;
  }

  public int getProvidersCount() {
    return internalGetProviders().getMap().size();
  }
  /**
   * <pre>
   * Map of provider names to JwtProviders.
   * .. code-block:: yaml
   *   providers:
   *     provider1:
   *        issuer: issuer1
   *        audiences:
   *        - audience1
   *        - audience2
   *        remote_jwks:
   *          http_uri:
   *            uri: https://example.com/.well-known/jwks.json
   *            cluster: example_jwks_cluster
   *      provider2:
   *        issuer: provider2
   *        local_jwks:
   *          inline_string: jwks_string
   * </pre>
   *
   * <code>map&lt;string, .envoy.extensions.filters.http.jwt_authn.v3.JwtProvider&gt; providers = 1;</code>
   */

  public boolean containsProviders(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetProviders().getMap().containsKey(key);
  }
  /**
   * Use {@link #getProvidersMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> getProviders() {
    return getProvidersMap();
  }
  /**
   * <pre>
   * Map of provider names to JwtProviders.
   * .. code-block:: yaml
   *   providers:
   *     provider1:
   *        issuer: issuer1
   *        audiences:
   *        - audience1
   *        - audience2
   *        remote_jwks:
   *          http_uri:
   *            uri: https://example.com/.well-known/jwks.json
   *            cluster: example_jwks_cluster
   *      provider2:
   *        issuer: provider2
   *        local_jwks:
   *          inline_string: jwks_string
   * </pre>
   *
   * <code>map&lt;string, .envoy.extensions.filters.http.jwt_authn.v3.JwtProvider&gt; providers = 1;</code>
   */

  public java.util.Map<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> getProvidersMap() {
    return internalGetProviders().getMap();
  }
  /**
   * <pre>
   * Map of provider names to JwtProviders.
   * .. code-block:: yaml
   *   providers:
   *     provider1:
   *        issuer: issuer1
   *        audiences:
   *        - audience1
   *        - audience2
   *        remote_jwks:
   *          http_uri:
   *            uri: https://example.com/.well-known/jwks.json
   *            cluster: example_jwks_cluster
   *      provider2:
   *        issuer: provider2
   *        local_jwks:
   *          inline_string: jwks_string
   * </pre>
   *
   * <code>map&lt;string, .envoy.extensions.filters.http.jwt_authn.v3.JwtProvider&gt; providers = 1;</code>
   */

  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider getProvidersOrDefault(
      java.lang.String key,
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> map =
        internalGetProviders().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Map of provider names to JwtProviders.
   * .. code-block:: yaml
   *   providers:
   *     provider1:
   *        issuer: issuer1
   *        audiences:
   *        - audience1
   *        - audience2
   *        remote_jwks:
   *          http_uri:
   *            uri: https://example.com/.well-known/jwks.json
   *            cluster: example_jwks_cluster
   *      provider2:
   *        issuer: provider2
   *        local_jwks:
   *          inline_string: jwks_string
   * </pre>
   *
   * <code>map&lt;string, .envoy.extensions.filters.http.jwt_authn.v3.JwtProvider&gt; providers = 1;</code>
   */

  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider getProvidersOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> map =
        internalGetProviders().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RULES_FIELD_NUMBER = 2;
  private java.util.List<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule> rules_;
  /**
   * <pre>
   * Specifies requirements based on the route matches. The first matched requirement will be
   * applied. If there are overlapped match conditions, please put the most specific match first.
   * Examples
   * .. code-block:: yaml
   * rules:
   *   - match:
   *       prefix: /healthz
   *   - match:
   *       prefix: /baz
   *     requires:
   *       provider_name: provider1
   *   - match:
   *       prefix: /foo
   *     requires:
   *       requires_any:
   *         requirements:
   *           - provider_name: provider1
   *           - provider_name: provider2
   *   - match:
   *       prefix: /bar
   *     requires:
   *       requires_all:
   *         requirements:
   *           - provider_name: provider1
   *           - provider_name: provider2
   * </pre>
   *
   * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
   */
  public java.util.List<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule> getRulesList() {
    return rules_;
  }
  /**
   * <pre>
   * Specifies requirements based on the route matches. The first matched requirement will be
   * applied. If there are overlapped match conditions, please put the most specific match first.
   * Examples
   * .. code-block:: yaml
   * rules:
   *   - match:
   *       prefix: /healthz
   *   - match:
   *       prefix: /baz
   *     requires:
   *       provider_name: provider1
   *   - match:
   *       prefix: /foo
   *     requires:
   *       requires_any:
   *         requirements:
   *           - provider_name: provider1
   *           - provider_name: provider2
   *   - match:
   *       prefix: /bar
   *     requires:
   *       requires_all:
   *         requirements:
   *           - provider_name: provider1
   *           - provider_name: provider2
   * </pre>
   *
   * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
   */
  public java.util.List<? extends io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRuleOrBuilder> 
      getRulesOrBuilderList() {
    return rules_;
  }
  /**
   * <pre>
   * Specifies requirements based on the route matches. The first matched requirement will be
   * applied. If there are overlapped match conditions, please put the most specific match first.
   * Examples
   * .. code-block:: yaml
   * rules:
   *   - match:
   *       prefix: /healthz
   *   - match:
   *       prefix: /baz
   *     requires:
   *       provider_name: provider1
   *   - match:
   *       prefix: /foo
   *     requires:
   *       requires_any:
   *         requirements:
   *           - provider_name: provider1
   *           - provider_name: provider2
   *   - match:
   *       prefix: /bar
   *     requires:
   *       requires_all:
   *         requirements:
   *           - provider_name: provider1
   *           - provider_name: provider2
   * </pre>
   *
   * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
   */
  public int getRulesCount() {
    return rules_.size();
  }
  /**
   * <pre>
   * Specifies requirements based on the route matches. The first matched requirement will be
   * applied. If there are overlapped match conditions, please put the most specific match first.
   * Examples
   * .. code-block:: yaml
   * rules:
   *   - match:
   *       prefix: /healthz
   *   - match:
   *       prefix: /baz
   *     requires:
   *       provider_name: provider1
   *   - match:
   *       prefix: /foo
   *     requires:
   *       requires_any:
   *         requirements:
   *           - provider_name: provider1
   *           - provider_name: provider2
   *   - match:
   *       prefix: /bar
   *     requires:
   *       requires_all:
   *         requirements:
   *           - provider_name: provider1
   *           - provider_name: provider2
   * </pre>
   *
   * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
   */
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule getRules(int index) {
    return rules_.get(index);
  }
  /**
   * <pre>
   * Specifies requirements based on the route matches. The first matched requirement will be
   * applied. If there are overlapped match conditions, please put the most specific match first.
   * Examples
   * .. code-block:: yaml
   * rules:
   *   - match:
   *       prefix: /healthz
   *   - match:
   *       prefix: /baz
   *     requires:
   *       provider_name: provider1
   *   - match:
   *       prefix: /foo
   *     requires:
   *       requires_any:
   *         requirements:
   *           - provider_name: provider1
   *           - provider_name: provider2
   *   - match:
   *       prefix: /bar
   *     requires:
   *       requires_all:
   *         requirements:
   *           - provider_name: provider1
   *           - provider_name: provider2
   * </pre>
   *
   * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
   */
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRuleOrBuilder getRulesOrBuilder(
      int index) {
    return rules_.get(index);
  }

  public static final int FILTER_STATE_RULES_FIELD_NUMBER = 3;
  private io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filterStateRules_;
  /**
   * <pre>
   * This message specifies Jwt requirements based on stream_info.filterState.
   * Other HTTP filters can use it to specify Jwt requirements dynamically.
   * The *rules* field above is checked first, if it could not find any matches,
   * check this one.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
   */
  public boolean hasFilterStateRules() {
    return filterStateRules_ != null;
  }
  /**
   * <pre>
   * This message specifies Jwt requirements based on stream_info.filterState.
   * Other HTTP filters can use it to specify Jwt requirements dynamically.
   * The *rules* field above is checked first, if it could not find any matches,
   * check this one.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
   */
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule getFilterStateRules() {
    return filterStateRules_ == null ? io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.getDefaultInstance() : filterStateRules_;
  }
  /**
   * <pre>
   * This message specifies Jwt requirements based on stream_info.filterState.
   * Other HTTP filters can use it to specify Jwt requirements dynamically.
   * The *rules* field above is checked first, if it could not find any matches,
   * check this one.
   * </pre>
   *
   * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
   */
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRuleOrBuilder getFilterStateRulesOrBuilder() {
    return getFilterStateRules();
  }

  public static final int BYPASS_CORS_PREFLIGHT_FIELD_NUMBER = 4;
  private boolean bypassCorsPreflight_;
  /**
   * <pre>
   * When set to true, bypass the `CORS preflight request
   * &lt;http://www.w3.org/TR/cors/#cross-origin-request-with-preflight&gt;`_ regardless of JWT
   * requirements specified in the rules.
   * </pre>
   *
   * <code>bool bypass_cors_preflight = 4;</code>
   */
  public boolean getBypassCorsPreflight() {
    return bypassCorsPreflight_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3
      .serializeStringMapTo(
        output,
        internalGetProviders(),
        ProvidersDefaultEntryHolder.defaultEntry,
        1);
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(2, rules_.get(i));
    }
    if (filterStateRules_ != null) {
      output.writeMessage(3, getFilterStateRules());
    }
    if (bypassCorsPreflight_ != false) {
      output.writeBool(4, bypassCorsPreflight_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> entry
         : internalGetProviders().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider>
      providers__ = ProvidersDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, providers__);
    }
    for (int i = 0; i < rules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, rules_.get(i));
    }
    if (filterStateRules_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getFilterStateRules());
    }
    if (bypassCorsPreflight_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(4, bypassCorsPreflight_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication other = (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication) obj;

    if (!internalGetProviders().equals(
        other.internalGetProviders())) return false;
    if (!getRulesList()
        .equals(other.getRulesList())) return false;
    if (hasFilterStateRules() != other.hasFilterStateRules()) return false;
    if (hasFilterStateRules()) {
      if (!getFilterStateRules()
          .equals(other.getFilterStateRules())) return false;
    }
    if (getBypassCorsPreflight()
        != other.getBypassCorsPreflight()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetProviders().getMap().isEmpty()) {
      hash = (37 * hash) + PROVIDERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetProviders().hashCode();
    }
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    if (hasFilterStateRules()) {
      hash = (37 * hash) + FILTER_STATE_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getFilterStateRules().hashCode();
    }
    hash = (37 * hash) + BYPASS_CORS_PREFLIGHT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getBypassCorsPreflight());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * This is the Envoy HTTP filter config for JWT authentication.
   * For example:
   * .. code-block:: yaml
   *   providers:
   *      provider1:
   *        issuer: issuer1
   *        audiences:
   *        - audience1
   *        - audience2
   *        remote_jwks:
   *          http_uri:
   *            uri: https://example.com/.well-known/jwks.json
   *            cluster: example_jwks_cluster
   *      provider2:
   *        issuer: issuer2
   *        local_jwks:
   *          inline_string: jwks_string
   *   rules:
   *      # Not jwt verification is required for /health path
   *      - match:
   *          prefix: /health
   *      # Jwt verification for provider1 is required for path prefixed with "prefix"
   *      - match:
   *          prefix: /prefix
   *        requires:
   *          provider_name: provider1
   *      # Jwt verification for either provider1 or provider2 is required for all other requests.
   *      - match:
   *          prefix: /
   *        requires:
   *          requires_any:
   *            requirements:
   *              - provider_name: provider1
   *              - provider_name: provider2
   * </pre>
   *
   * Protobuf type {@code envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication)
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthenticationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtAuthentication_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 1:
          return internalGetProviders();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 1:
          return internalGetMutableProviders();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtAuthentication_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.class, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getRulesFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      internalGetMutableProviders().clear();
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        rulesBuilder_.clear();
      }
      if (filterStateRulesBuilder_ == null) {
        filterStateRules_ = null;
      } else {
        filterStateRules_ = null;
        filterStateRulesBuilder_ = null;
      }
      bypassCorsPreflight_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.ConfigProto.internal_static_envoy_extensions_filters_http_jwt_authn_v3_JwtAuthentication_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication getDefaultInstanceForType() {
      return io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication build() {
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication buildPartial() {
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication result = new io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication(this);
      int from_bitField0_ = bitField0_;
      result.providers_ = internalGetProviders();
      result.providers_.makeImmutable();
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
      if (filterStateRulesBuilder_ == null) {
        result.filterStateRules_ = filterStateRules_;
      } else {
        result.filterStateRules_ = filterStateRulesBuilder_.build();
      }
      result.bypassCorsPreflight_ = bypassCorsPreflight_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication) {
        return mergeFrom((io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication other) {
      if (other == io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication.getDefaultInstance()) return this;
      internalGetMutableProviders().mergeFrom(
          other.internalGetProviders());
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000002);
            rulesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getRulesFieldBuilder() : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      if (other.hasFilterStateRules()) {
        mergeFilterStateRules(other.getFilterStateRules());
      }
      if (other.getBypassCorsPreflight() != false) {
        setBypassCorsPreflight(other.getBypassCorsPreflight());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private com.google.protobuf.MapField<
        java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> providers_;
    private com.google.protobuf.MapField<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider>
    internalGetProviders() {
      if (providers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ProvidersDefaultEntryHolder.defaultEntry);
      }
      return providers_;
    }
    private com.google.protobuf.MapField<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider>
    internalGetMutableProviders() {
      onChanged();;
      if (providers_ == null) {
        providers_ = com.google.protobuf.MapField.newMapField(
            ProvidersDefaultEntryHolder.defaultEntry);
      }
      if (!providers_.isMutable()) {
        providers_ = providers_.copy();
      }
      return providers_;
    }

    public int getProvidersCount() {
      return internalGetProviders().getMap().size();
    }
    /**
     * <pre>
     * Map of provider names to JwtProviders.
     * .. code-block:: yaml
     *   providers:
     *     provider1:
     *        issuer: issuer1
     *        audiences:
     *        - audience1
     *        - audience2
     *        remote_jwks:
     *          http_uri:
     *            uri: https://example.com/.well-known/jwks.json
     *            cluster: example_jwks_cluster
     *      provider2:
     *        issuer: provider2
     *        local_jwks:
     *          inline_string: jwks_string
     * </pre>
     *
     * <code>map&lt;string, .envoy.extensions.filters.http.jwt_authn.v3.JwtProvider&gt; providers = 1;</code>
     */

    public boolean containsProviders(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetProviders().getMap().containsKey(key);
    }
    /**
     * Use {@link #getProvidersMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> getProviders() {
      return getProvidersMap();
    }
    /**
     * <pre>
     * Map of provider names to JwtProviders.
     * .. code-block:: yaml
     *   providers:
     *     provider1:
     *        issuer: issuer1
     *        audiences:
     *        - audience1
     *        - audience2
     *        remote_jwks:
     *          http_uri:
     *            uri: https://example.com/.well-known/jwks.json
     *            cluster: example_jwks_cluster
     *      provider2:
     *        issuer: provider2
     *        local_jwks:
     *          inline_string: jwks_string
     * </pre>
     *
     * <code>map&lt;string, .envoy.extensions.filters.http.jwt_authn.v3.JwtProvider&gt; providers = 1;</code>
     */

    public java.util.Map<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> getProvidersMap() {
      return internalGetProviders().getMap();
    }
    /**
     * <pre>
     * Map of provider names to JwtProviders.
     * .. code-block:: yaml
     *   providers:
     *     provider1:
     *        issuer: issuer1
     *        audiences:
     *        - audience1
     *        - audience2
     *        remote_jwks:
     *          http_uri:
     *            uri: https://example.com/.well-known/jwks.json
     *            cluster: example_jwks_cluster
     *      provider2:
     *        issuer: provider2
     *        local_jwks:
     *          inline_string: jwks_string
     * </pre>
     *
     * <code>map&lt;string, .envoy.extensions.filters.http.jwt_authn.v3.JwtProvider&gt; providers = 1;</code>
     */

    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider getProvidersOrDefault(
        java.lang.String key,
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> map =
          internalGetProviders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Map of provider names to JwtProviders.
     * .. code-block:: yaml
     *   providers:
     *     provider1:
     *        issuer: issuer1
     *        audiences:
     *        - audience1
     *        - audience2
     *        remote_jwks:
     *          http_uri:
     *            uri: https://example.com/.well-known/jwks.json
     *            cluster: example_jwks_cluster
     *      provider2:
     *        issuer: provider2
     *        local_jwks:
     *          inline_string: jwks_string
     * </pre>
     *
     * <code>map&lt;string, .envoy.extensions.filters.http.jwt_authn.v3.JwtProvider&gt; providers = 1;</code>
     */

    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider getProvidersOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> map =
          internalGetProviders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearProviders() {
      internalGetMutableProviders().getMutableMap()
          .clear();
      return this;
    }
    /**
     * <pre>
     * Map of provider names to JwtProviders.
     * .. code-block:: yaml
     *   providers:
     *     provider1:
     *        issuer: issuer1
     *        audiences:
     *        - audience1
     *        - audience2
     *        remote_jwks:
     *          http_uri:
     *            uri: https://example.com/.well-known/jwks.json
     *            cluster: example_jwks_cluster
     *      provider2:
     *        issuer: provider2
     *        local_jwks:
     *          inline_string: jwks_string
     * </pre>
     *
     * <code>map&lt;string, .envoy.extensions.filters.http.jwt_authn.v3.JwtProvider&gt; providers = 1;</code>
     */

    public Builder removeProviders(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableProviders().getMutableMap()
          .remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider>
    getMutableProviders() {
      return internalGetMutableProviders().getMutableMap();
    }
    /**
     * <pre>
     * Map of provider names to JwtProviders.
     * .. code-block:: yaml
     *   providers:
     *     provider1:
     *        issuer: issuer1
     *        audiences:
     *        - audience1
     *        - audience2
     *        remote_jwks:
     *          http_uri:
     *            uri: https://example.com/.well-known/jwks.json
     *            cluster: example_jwks_cluster
     *      provider2:
     *        issuer: provider2
     *        local_jwks:
     *          inline_string: jwks_string
     * </pre>
     *
     * <code>map&lt;string, .envoy.extensions.filters.http.jwt_authn.v3.JwtProvider&gt; providers = 1;</code>
     */
    public Builder putProviders(
        java.lang.String key,
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      internalGetMutableProviders().getMutableMap()
          .put(key, value);
      return this;
    }
    /**
     * <pre>
     * Map of provider names to JwtProviders.
     * .. code-block:: yaml
     *   providers:
     *     provider1:
     *        issuer: issuer1
     *        audiences:
     *        - audience1
     *        - audience2
     *        remote_jwks:
     *          http_uri:
     *            uri: https://example.com/.well-known/jwks.json
     *            cluster: example_jwks_cluster
     *      provider2:
     *        issuer: provider2
     *        local_jwks:
     *          inline_string: jwks_string
     * </pre>
     *
     * <code>map&lt;string, .envoy.extensions.filters.http.jwt_authn.v3.JwtProvider&gt; providers = 1;</code>
     */

    public Builder putAllProviders(
        java.util.Map<java.lang.String, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtProvider> values) {
      internalGetMutableProviders().getMutableMap()
          .putAll(values);
      return this;
    }

    private java.util.List<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule> rules_ =
      java.util.Collections.emptyList();
    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        rules_ = new java.util.ArrayList<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule>(rules_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRuleOrBuilder> rulesBuilder_;

    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public java.util.List<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule> getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public Builder setRules(
        int index, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public Builder setRules(
        int index, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public Builder addRules(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public Builder addRules(
        int index, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public Builder addRules(
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public Builder addRules(
        int index, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public Builder addAllRules(
        java.lang.Iterable<? extends io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule> values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.Builder getRulesBuilder(
        int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRuleOrBuilder getRulesOrBuilder(
        int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);  } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public java.util.List<? extends io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRuleOrBuilder> 
         getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.Builder addRulesBuilder() {
      return getRulesFieldBuilder().addBuilder(
          io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.Builder addRulesBuilder(
        int index) {
      return getRulesFieldBuilder().addBuilder(
          index, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies requirements based on the route matches. The first matched requirement will be
     * applied. If there are overlapped match conditions, please put the most specific match first.
     * Examples
     * .. code-block:: yaml
     * rules:
     *   - match:
     *       prefix: /healthz
     *   - match:
     *       prefix: /baz
     *     requires:
     *       provider_name: provider1
     *   - match:
     *       prefix: /foo
     *     requires:
     *       requires_any:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     *   - match:
     *       prefix: /bar
     *     requires:
     *       requires_all:
     *         requirements:
     *           - provider_name: provider1
     *           - provider_name: provider2
     * </pre>
     *
     * <code>repeated .envoy.extensions.filters.http.jwt_authn.v3.RequirementRule rules = 2;</code>
     */
    public java.util.List<io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.Builder> 
         getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRuleOrBuilder> 
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRule.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.RequirementRuleOrBuilder>(
                rules_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    private io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filterStateRules_;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRuleOrBuilder> filterStateRulesBuilder_;
    /**
     * <pre>
     * This message specifies Jwt requirements based on stream_info.filterState.
     * Other HTTP filters can use it to specify Jwt requirements dynamically.
     * The *rules* field above is checked first, if it could not find any matches,
     * check this one.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
     */
    public boolean hasFilterStateRules() {
      return filterStateRulesBuilder_ != null || filterStateRules_ != null;
    }
    /**
     * <pre>
     * This message specifies Jwt requirements based on stream_info.filterState.
     * Other HTTP filters can use it to specify Jwt requirements dynamically.
     * The *rules* field above is checked first, if it could not find any matches,
     * check this one.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule getFilterStateRules() {
      if (filterStateRulesBuilder_ == null) {
        return filterStateRules_ == null ? io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.getDefaultInstance() : filterStateRules_;
      } else {
        return filterStateRulesBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * This message specifies Jwt requirements based on stream_info.filterState.
     * Other HTTP filters can use it to specify Jwt requirements dynamically.
     * The *rules* field above is checked first, if it could not find any matches,
     * check this one.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
     */
    public Builder setFilterStateRules(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule value) {
      if (filterStateRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filterStateRules_ = value;
        onChanged();
      } else {
        filterStateRulesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * This message specifies Jwt requirements based on stream_info.filterState.
     * Other HTTP filters can use it to specify Jwt requirements dynamically.
     * The *rules* field above is checked first, if it could not find any matches,
     * check this one.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
     */
    public Builder setFilterStateRules(
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.Builder builderForValue) {
      if (filterStateRulesBuilder_ == null) {
        filterStateRules_ = builderForValue.build();
        onChanged();
      } else {
        filterStateRulesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * This message specifies Jwt requirements based on stream_info.filterState.
     * Other HTTP filters can use it to specify Jwt requirements dynamically.
     * The *rules* field above is checked first, if it could not find any matches,
     * check this one.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
     */
    public Builder mergeFilterStateRules(io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule value) {
      if (filterStateRulesBuilder_ == null) {
        if (filterStateRules_ != null) {
          filterStateRules_ =
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.newBuilder(filterStateRules_).mergeFrom(value).buildPartial();
        } else {
          filterStateRules_ = value;
        }
        onChanged();
      } else {
        filterStateRulesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * This message specifies Jwt requirements based on stream_info.filterState.
     * Other HTTP filters can use it to specify Jwt requirements dynamically.
     * The *rules* field above is checked first, if it could not find any matches,
     * check this one.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
     */
    public Builder clearFilterStateRules() {
      if (filterStateRulesBuilder_ == null) {
        filterStateRules_ = null;
        onChanged();
      } else {
        filterStateRules_ = null;
        filterStateRulesBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * This message specifies Jwt requirements based on stream_info.filterState.
     * Other HTTP filters can use it to specify Jwt requirements dynamically.
     * The *rules* field above is checked first, if it could not find any matches,
     * check this one.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.Builder getFilterStateRulesBuilder() {
      
      onChanged();
      return getFilterStateRulesFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * This message specifies Jwt requirements based on stream_info.filterState.
     * Other HTTP filters can use it to specify Jwt requirements dynamically.
     * The *rules* field above is checked first, if it could not find any matches,
     * check this one.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
     */
    public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRuleOrBuilder getFilterStateRulesOrBuilder() {
      if (filterStateRulesBuilder_ != null) {
        return filterStateRulesBuilder_.getMessageOrBuilder();
      } else {
        return filterStateRules_ == null ?
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.getDefaultInstance() : filterStateRules_;
      }
    }
    /**
     * <pre>
     * This message specifies Jwt requirements based on stream_info.filterState.
     * Other HTTP filters can use it to specify Jwt requirements dynamically.
     * The *rules* field above is checked first, if it could not find any matches,
     * check this one.
     * </pre>
     *
     * <code>.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule filter_state_rules = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRuleOrBuilder> 
        getFilterStateRulesFieldBuilder() {
      if (filterStateRulesBuilder_ == null) {
        filterStateRulesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRule.Builder, io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.FilterStateRuleOrBuilder>(
                getFilterStateRules(),
                getParentForChildren(),
                isClean());
        filterStateRules_ = null;
      }
      return filterStateRulesBuilder_;
    }

    private boolean bypassCorsPreflight_ ;
    /**
     * <pre>
     * When set to true, bypass the `CORS preflight request
     * &lt;http://www.w3.org/TR/cors/#cross-origin-request-with-preflight&gt;`_ regardless of JWT
     * requirements specified in the rules.
     * </pre>
     *
     * <code>bool bypass_cors_preflight = 4;</code>
     */
    public boolean getBypassCorsPreflight() {
      return bypassCorsPreflight_;
    }
    /**
     * <pre>
     * When set to true, bypass the `CORS preflight request
     * &lt;http://www.w3.org/TR/cors/#cross-origin-request-with-preflight&gt;`_ regardless of JWT
     * requirements specified in the rules.
     * </pre>
     *
     * <code>bool bypass_cors_preflight = 4;</code>
     */
    public Builder setBypassCorsPreflight(boolean value) {
      
      bypassCorsPreflight_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * When set to true, bypass the `CORS preflight request
     * &lt;http://www.w3.org/TR/cors/#cross-origin-request-with-preflight&gt;`_ regardless of JWT
     * requirements specified in the rules.
     * </pre>
     *
     * <code>bool bypass_cors_preflight = 4;</code>
     */
    public Builder clearBypassCorsPreflight() {
      
      bypassCorsPreflight_ = false;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication)
  }

  // @@protoc_insertion_point(class_scope:envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication)
  private static final io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication();
  }

  public static io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JwtAuthentication>
      PARSER = new com.google.protobuf.AbstractParser<JwtAuthentication>() {
    @java.lang.Override
    public JwtAuthentication parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new JwtAuthentication(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<JwtAuthentication> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JwtAuthentication> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.extensions.filters.http.jwt_authn.v3.JwtAuthentication getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

