/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.BasicBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractBasicBuilder<T extends BasicBuilder>
implements BasicBuilder {
    private URI uri;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public T uri(URI uri) {
        this.uri = uri;
        return (T)this;
    }

    public T header(String name, String value) {
        this.headers.compute(name, (k, v) -> {
            if (v == null) {
                v = new ArrayList<String>();
            }
            v.add(value);
            return v;
        });
        return (T)this;
    }

    public T setHeader(String name, String value) {
        this.headers.put(name, new ArrayList<String>(Collections.singletonList(value)));
        return (T)this;
    }

    protected final URI getUri() {
        return this.uri;
    }

    protected final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    protected final void setHeaders(Map<String, List<String>> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
    }
}

