/*
 * Decompiled with CFR 0.152.
 */
package io.github.bigmouthcn.chatkit4j.agent;

import com.theokanning.openai.completion.chat.AssistantMessage;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.service.OpenAiService;
import io.github.bigmouthcn.chatkit4j.agent.Agent;
import io.github.bigmouthcn.chatkit4j.agent.AgentRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChatAgent<T extends AgentRequest>
implements Agent<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractChatAgent.class);
    private final OpenAiService openAiService;

    protected AbstractChatAgent(OpenAiService openAiService) {
        this.openAiService = openAiService;
    }

    protected abstract ChatCompletionRequest createBasic();

    protected abstract List<ChatMessage> createChatMessages(T var1) throws Exception;

    protected abstract Object createResponseOnCompletion(T var1, AssistantMessage var2);

    protected abstract Object createResponseOnException(T var1);

    @Override
    public Object apply(T t) {
        try {
            ChatCompletionRequest requestBody = this.createBasic();
            if (requestBody == null) {
                return this.createResponseOnException(t);
            }
            List<ChatMessage> chatMessages = this.createChatMessages(t);
            requestBody.setStream(Boolean.valueOf(false));
            requestBody.setMessages(chatMessages);
            ChatCompletionResult completion = this.openAiService.createChatCompletion(requestBody);
            AssistantMessage message = ((ChatCompletionChoice)completion.getChoices().get(0)).getMessage();
            String textContent = message.getTextContent();
            log.info("{}", (Object)textContent);
            return this.createResponseOnCompletion(t, message);
        }
        catch (Exception e) {
            log.error("chat error", (Throwable)e);
            return this.createResponseOnException(t);
        }
    }
}

