/*
 * Decompiled with CFR 0.152.
 */
package io.github.bigmouthcn.chatkit4j.agent;

import com.google.common.collect.Lists;
import com.theokanning.openai.function.FunctionDefinition;
import io.github.bigmouthcn.chatkit4j.agent.Agent;
import io.github.bigmouthcn.chatkit4j.agent.AgentRequest;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ClassUtils;

public class AgentFactory
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(AgentFactory.class);
    private Collection<FunctionDefinition> functionDefinitions = Lists.newArrayList();

    public Collection<FunctionDefinition> getFunctionDefinitions() {
        return this.functionDefinitions;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Agent) {
            Agent agent = (Agent)bean;
            Class clazz = ClassUtils.getUserClass((Object)agent);
            Type genericSuperclass = clazz.getGenericSuperclass();
            boolean createdFun = this.isCreatedFun(agent, genericSuperclass);
            if (!createdFun) {
                Type genericInterface;
                Type[] genericInterfaces;
                Type[] typeArray = genericInterfaces = clazz.getGenericInterfaces();
                int n = typeArray.length;
                for (int i = 0; i < n && !(createdFun = this.isCreatedFun(agent, genericInterface = typeArray[i])); ++i) {
                }
            }
            if (!createdFun) {
                throw new BeanCreationException("Failed to create Agent definition for bean: " + clazz.getName());
            }
        }
        return bean;
    }

    private boolean isCreatedFun(Agent<AgentRequest> agent, Type superclassOrInterface) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (superclassOrInterface instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)superclassOrInterface).getActualTypeArguments()).length > 0) {
            Class reqType = (Class)actualTypeArguments[0];
            this.functionDefinitions.add(this.create(reqType, agent));
            return true;
        }
        return false;
    }

    private FunctionDefinition create(Class<AgentRequest> reqClass, Agent<AgentRequest> agent) {
        String functionName = agent.getFunctionName();
        String functionDescription = agent.getFunctionDescription();
        FunctionDefinition definition = new FunctionDefinition.Builder().name(functionName).description(functionDescription).parametersDefinitionByClass(reqClass).executor(agent).build();
        if (log.isInfoEnabled()) {
            log.info("Created Agent definition for bean: " + agent.getClass().getName());
        }
        return definition;
    }
}

