/*
 * Decompiled with CFR 0.152.
 */
package io.github.bigmouthcn.chatkit4j.agent.charts;

import com.google.common.collect.Lists;
import com.theokanning.openai.completion.chat.AssistantMessage;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.SystemMessage;
import com.theokanning.openai.completion.chat.UserMessage;
import com.theokanning.openai.service.OpenAiService;
import io.github.bigmouthcn.chatkit4j.AgentConfig;
import io.github.bigmouthcn.chatkit4j.agent.AbstractChatAgent;
import io.github.bigmouthcn.chatkit4j.agent.charts.EChartsSystemPromptFetcher;
import io.github.bigmouthcn.chatkit4j.agent.charts.GenerateEChartsOptionDataRequest;
import io.github.bigmouthcn.chatkit4j.agent.charts.GenerateEChartsOptionDataResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class GenerateEChartsOptionDataAgent
extends AbstractChatAgent<GenerateEChartsOptionDataRequest> {
    private final EChartsSystemPromptFetcher eChartsSystemPromptFetcher;
    private final AgentConfig.EChartsAgentConfig echartsAgentConfig;

    public GenerateEChartsOptionDataAgent(OpenAiService openAiService, EChartsSystemPromptFetcher eChartsSystemPromptFetcher, AgentConfig.EChartsAgentConfig echartsAgentConfig) {
        super(openAiService);
        this.eChartsSystemPromptFetcher = eChartsSystemPromptFetcher;
        this.echartsAgentConfig = echartsAgentConfig;
    }

    @Override
    public String getFunctionName() {
        return "generate-echarts-options-data";
    }

    @Override
    public String getFunctionDescription() {
        return "\u6839\u636e\u8f93\u5165\u6570\u636e\u751f\u6210echarts\u56fe\u8868\u7684option\u53c2\u6570\u503c";
    }

    @Override
    protected ChatCompletionRequest createBasic() {
        ChatCompletionRequest.ChatCompletionRequestBuilder builder = ChatCompletionRequest.builder();
        if (Objects.nonNull(this.echartsAgentConfig.getMaxTokens())) {
            builder.maxTokens(this.echartsAgentConfig.getMaxTokens());
        }
        return builder.model(this.echartsAgentConfig.getModel()).temperature(this.echartsAgentConfig.getTemperature()).build();
    }

    @Override
    protected List<ChatMessage> createChatMessages(GenerateEChartsOptionDataRequest generateEChartsOptionDataRequest) {
        ArrayList messages = Lists.newArrayList();
        SystemMessage systemMessage = this.eChartsSystemPromptFetcher.fetch();
        if (systemMessage != null) {
            messages.add(systemMessage);
        }
        String data = generateEChartsOptionDataRequest.getData();
        messages.add(new UserMessage(data));
        return messages;
    }

    @Override
    protected Object createResponseOnCompletion(GenerateEChartsOptionDataRequest generateEChartsOptionDataRequest, AssistantMessage assistantMessage) {
        return new GenerateEChartsOptionDataResponse().setSuccess(true).setEchartsOption(assistantMessage.getTextContent());
    }

    @Override
    protected Object createResponseOnException(GenerateEChartsOptionDataRequest generateEChartsOptionDataRequest) {
        return new GenerateEChartsOptionDataResponse().setSuccess(false);
    }
}

