/*
 * Decompiled with CFR 0.152.
 */
package io.github.bigmouthcn.chatkit4j.autoconfigure;

import io.github.bigmouthcn.chatkit4j.WebConfig;
import java.time.Duration;
import java.util.Optional;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@EnableConfigurationProperties(value={WebConfig.class})
public class Chatkit4jMvcConfigurer
implements WebMvcConfigurer {
    private final WebConfig config;

    public Chatkit4jMvcConfigurer(WebConfig config) {
        this.config = config;
    }

    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.config.getAsyncTaskCorePoolSize());
        executor.setMaxPoolSize(this.config.getAsyncTaskMaxPoolSize());
        executor.setQueueCapacity(this.config.getAsyncTaskQueueCapacity());
        executor.initialize();
        configurer.setTaskExecutor((AsyncTaskExecutor)executor);
        configurer.setDefaultTimeout(Optional.ofNullable(this.config.getAsyncRequestTimeout()).orElse(Duration.ofMinutes(5L)).toMillis());
    }
}

