/*
 * Decompiled with CFR 0.152.
 */
package io.github.bigmouthcn.chatkit4j.autoconfigure;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.theokanning.openai.function.FunctionDefinition;
import com.theokanning.openai.function.FunctionExecutorManager;
import com.theokanning.openai.service.OpenAiService;
import io.github.bigmouthcn.chatkit4j.OpenAiConfig;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executors;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={OpenAiConfig.class})
public class OpenAiServiceAutoConfiguration {
    public static ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy(PropertyNamingStrategies.LOWER_CAMEL_CASE);

    @Bean
    public OpenAiService openAiService(OpenAiConfig openAiConfig) {
        String baseUrl = openAiConfig.getBaseUrl();
        String accessKey = openAiConfig.getAccessKey();
        Duration timeout = openAiConfig.getTimeout();
        return new OpenAiService(accessKey, timeout, baseUrl);
    }

    public static FunctionExecutorManager createFunctionExecutorManager(List<FunctionDefinition> functionDefinitionList) {
        return new FunctionExecutorManager(MAPPER, Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()), functionDefinitionList);
    }
}

