/*
 * Decompiled with CFR 0.152.
 */
package io.github.bigmouthcn.chatkit4j.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.theokanning.openai.assistants.run.ToolChoice;
import com.theokanning.openai.completion.chat.AssistantMessage;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionChunk;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.completion.chat.ChatFunctionCall;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatTool;
import com.theokanning.openai.completion.chat.ChatToolCall;
import com.theokanning.openai.completion.chat.ToolMessage;
import com.theokanning.openai.function.FunctionDefinition;
import com.theokanning.openai.function.FunctionExecutorManager;
import com.theokanning.openai.service.ChatMessageAccumulator;
import com.theokanning.openai.service.ChatMessageAccumulatorWrapper;
import com.theokanning.openai.service.OpenAiService;
import io.github.bigmouthcn.chatkit4j.agent.AgentExecuteException;
import io.github.bigmouthcn.chatkit4j.agent.AgentFactory;
import io.github.bigmouthcn.chatkit4j.autoconfigure.OpenAiServiceAutoConfiguration;
import io.github.bigmouthcn.chatkit4j.utils.NamedThreadFactory;
import io.github.bigmouthcn.chatkit4j.utils.SystemPromptFetcher;
import io.reactivex.Flowable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
public class ChatController {
    private static final Logger log = LoggerFactory.getLogger(ChatController.class);
    private final OpenAiService openAiService;
    private final ExecutorService executor;
    private final AgentFactory agentFactory;
    private final SystemPromptFetcher systemPromptFetcher;

    public ChatController(OpenAiService openAiService, AgentFactory agentFactory, SystemPromptFetcher systemPromptFetcher) {
        this.openAiService = openAiService;
        this.agentFactory = agentFactory;
        this.systemPromptFetcher = systemPromptFetcher;
        this.executor = new ThreadPoolExecutor(200, 200, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("chat"), new ThreadPoolExecutor.AbortPolicy());
    }

    @GetMapping(value={"/v1/agents"})
    public Object getAgents() {
        return this.agentFactory.getFunctionDefinitions();
    }

    @PostMapping(value={"/v1/chat/completions"})
    public Object chatCompletions(@RequestBody ChatCompletionRequest requestBody) {
        ChatCompletionResult completion;
        boolean stream;
        List chatMessages = requestBody.getMessages();
        ChatMessage systemMessage = this.createSystemMessage();
        if (null != systemMessage) {
            chatMessages.add(0, systemMessage);
        }
        List<FunctionDefinition> chatFunctions = this.createTools();
        FunctionExecutorManager functionExecutorManager = OpenAiServiceAutoConfiguration.createFunctionExecutorManager(chatFunctions);
        List chatTools = chatFunctions.stream().map(ChatTool::new).collect(Collectors.toList());
        if (!chatTools.isEmpty()) {
            requestBody.setTools(chatTools);
            requestBody.setToolChoice(ToolChoice.AUTO);
        }
        if (stream = Optional.ofNullable(requestBody.getStream()).orElse(false).booleanValue()) {
            SseEmitter sseEmitter = new SseEmitter();
            this.executor.submit(() -> {
                while (true) {
                    Flowable streamedChatCompletion = this.openAiService.streamChatCompletion(requestBody);
                    AssistantMessage accumulatedMessage = ((ChatMessageAccumulatorWrapper)this.openAiService.mapStreamToAccumulatorWrapper(streamedChatCompletion).doOnNext(chatMessageAccumulatorWrapper -> {
                        ChatCompletionChunk chatCompletionChunk;
                        String source;
                        ChatMessageAccumulator chatMessageAccumulator = chatMessageAccumulatorWrapper.getChatMessageAccumulator();
                        if (!chatMessageAccumulator.isFunctionCall() && StringUtils.isNotEmpty((CharSequence)(source = (chatCompletionChunk = chatMessageAccumulatorWrapper.getChatCompletionChunk()).getSource()))) {
                            byte[] bytes = source.getBytes(StandardCharsets.UTF_8);
                            sseEmitter.send(SseEmitter.event().data((Object)bytes, MediaType.APPLICATION_JSON_UTF8));
                        }
                    }).doOnError(throwable -> {
                        sseEmitter.completeWithError(throwable);
                        log.error("streamChatCompletion error", throwable);
                    }).lastElement().blockingGet()).getChatMessageAccumulator().getAccumulatedMessage();
                    chatMessages.add(accumulatedMessage);
                    List functionCalls = accumulatedMessage.getToolCalls();
                    if (Objects.isNull(functionCalls)) break;
                    List<ToolMessage> executed = this.executeFunctions(functionExecutorManager, functionCalls);
                    chatMessages.addAll(executed);
                }
                sseEmitter.complete();
            });
            return sseEmitter;
        }
        while (true) {
            completion = this.openAiService.createChatCompletion(requestBody);
            AssistantMessage message = ((ChatCompletionChoice)completion.getChoices().get(0)).getMessage();
            chatMessages.add(message);
            List functionCalls = message.getToolCalls();
            if (!Objects.nonNull(functionCalls)) break;
            List<ToolMessage> executed = this.executeFunctions(functionExecutorManager, functionCalls);
            chatMessages.addAll(executed);
        }
        return completion;
    }

    private List<ToolMessage> executeFunctions(FunctionExecutorManager functionExecutorManager, List<ChatToolCall> functionCalls) {
        ArrayList<ToolMessage> chatMessages = new ArrayList<ToolMessage>();
        for (ChatToolCall functionCall : functionCalls) {
            ChatFunctionCall function = functionCall.getFunction();
            String name = function.getName();
            JsonNode arguments = function.getArguments();
            log.info("execution tool: {} - {}", (Object)name, (Object)arguments);
            String toolId = functionCall.getId();
            ToolMessage toolMessage = null;
            try {
                toolMessage = functionExecutorManager.executeAndConvertToChatMessage(name, arguments, toolId);
                log.info("executed: {}", (Object)toolMessage.getTextContent());
            }
            catch (AgentExecuteException e) {
                toolMessage = new ToolMessage(e.getMessage(), toolId);
                log.warn("executed: {}", (Object)e.getMessage());
            }
            catch (Exception e) {
                String content = "execute tool error: " + e.getMessage();
                toolMessage = new ToolMessage(content, toolId);
                log.error("execute tool error: {}", (Object)e.getMessage());
            }
            chatMessages.add(toolMessage);
        }
        return chatMessages;
    }

    private ChatMessage createSystemMessage() {
        return this.systemPromptFetcher.fetch();
    }

    private List<FunctionDefinition> createTools() {
        Collection<FunctionDefinition> functionDefinitions = this.agentFactory.getFunctionDefinitions();
        return new ArrayList<FunctionDefinition>(functionDefinitions);
    }
}

