/*
 * Decompiled with CFR 0.152.
 */
package io.github.bigmouthcn.chatkit4j.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public final class PromptUtils {
    private static final Logger log = LoggerFactory.getLogger(PromptUtils.class);

    public static String fetch(String fileName) {
        return PromptUtils.fetch(fileName, null);
    }

    public static String fetch(String fileName, Map<String, String> replaced) {
        try {
            String md = PromptUtils.readFullFromUserDir(fileName);
            if (StringUtils.isBlank((CharSequence)md)) {
                md = PromptUtils.readFull(fileName);
            }
            if (MapUtils.isNotEmpty(replaced)) {
                for (Map.Entry<String, String> entry : replaced.entrySet()) {
                    md = md.replaceAll(entry.getKey(), entry.getValue());
                }
            }
            return md;
        }
        catch (IORuntimeException | IOException e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25", e);
            return null;
        }
    }

    public static String readFullFromUserDir(String fileName) {
        try {
            String userDir = System.getProperty("user.home");
            File file = new File(userDir + File.separator + fileName);
            if (!FileUtil.exist((File)file)) {
                return null;
            }
            return FileUtil.readUtf8String((File)file);
        }
        catch (IORuntimeException e) {
            return null;
        }
    }

    public static void writeFullFromUserDir(String fileName, String content) {
        String userDir = System.getProperty("user.home");
        File file = new File(userDir + File.separator + fileName);
        FileUtil.writeUtf8String((String)content, (File)file);
    }

    public static void deleteFromUserDir(String fileName) {
        String userDir = System.getProperty("user.home");
        File file = new File(userDir + File.separator + fileName);
        FileUtil.del((File)file);
    }

    public static String readFull(String fileName) throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(fileName);
        if (!classPathResource.exists()) {
            return null;
        }
        return IoUtil.read((InputStream)classPathResource.getInputStream(), (Charset)StandardCharsets.UTF_8);
    }
}

