/*
 * Decompiled with CFR 0.152.
 */
package io.github.bigmouthcn.chatkit4j.utils.pair;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.bigmouthcn.chatkit4j.utils.pair.Value;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DefaultValue
implements Value {
    private static final char DEFAULT_SPLIT_CHAR = ',';
    private final String value;

    public DefaultValue(String value) {
        this.value = value;
    }

    @Override
    public String of() {
        return this.value;
    }

    @Override
    public List<String> ofArrayList() {
        if (StringUtils.isBlank((CharSequence)this.value)) {
            return null;
        }
        return Lists.newArrayList((Object[])this.simpleSplitToArray());
    }

    @Override
    public Integer ofInt() {
        return TypeUtils.castToInt((Object)this.value);
    }

    @Override
    public int ofInt(int defaultValue) {
        return NumberUtils.toInt((String)this.value, (int)defaultValue);
    }

    @Override
    public Boolean ofBoolean() {
        return TypeUtils.castToBoolean((Object)this.value);
    }

    @Override
    public boolean ofBoolean(boolean defaultValue) {
        Boolean b = this.ofBoolean();
        return null == b ? defaultValue : b;
    }

    @Override
    public Set<String> ofHashSet() {
        if (StringUtils.isBlank((CharSequence)this.value)) {
            return null;
        }
        return Sets.newHashSet((Object[])this.simpleSplitToArray());
    }

    @Override
    public <T> T toObject(Class<T> cls) {
        if (StringUtils.isBlank((CharSequence)this.value)) {
            return null;
        }
        return (T)JSONObject.parseObject((String)this.value, cls);
    }

    private String[] simpleSplitToArray() {
        return StringUtils.split((String)this.value, (char)',');
    }
}

