/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.tracing;

import brave.Span;
import brave.propagation.TraceContextOrSamplingFlags;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.tracing.NoOpTracing;
import io.lettuce.core.tracing.TraceContext;
import io.lettuce.core.tracing.TraceContextProvider;
import io.lettuce.core.tracing.Tracer;
import io.lettuce.core.tracing.TracerProvider;
import io.lettuce.core.tracing.Tracing;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import zipkin2.Endpoint;

public class BraveTracing
implements Tracing {
    private final BraveTracer tracer;
    private final BraveTracingOptions tracingOptions;
    private final boolean includeCommandArgsInSpanTags;

    private BraveTracing(Builder builder) {
        LettuceAssert.notNull((Object)builder.tracing, "Tracing must not be null");
        LettuceAssert.notNull((Object)builder.serviceName, "Service name must not be null");
        this.tracingOptions = new BraveTracingOptions(builder.serviceName, builder.endpointCustomizer, builder.spanCustomizer);
        this.tracer = new BraveTracer(builder.tracing, this.tracingOptions, builder.includeCommandArgsInSpanTags);
        this.includeCommandArgsInSpanTags = builder.includeCommandArgsInSpanTags;
    }

    public static BraveTracing create(brave.Tracing tracing) {
        return BraveTracing.builder().tracing(tracing).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean includeCommandArgsInSpanTags() {
        return this.includeCommandArgsInSpanTags;
    }

    @Override
    public TracerProvider getTracerProvider() {
        return () -> this.tracer;
    }

    @Override
    public TraceContextProvider initialTraceContextProvider() {
        return BraveTraceContextProvider.INSTANCE;
    }

    @Override
    public Tracing.Endpoint createEndpoint(SocketAddress socketAddress) {
        Endpoint.Builder builder = Endpoint.newBuilder().serviceName(this.tracingOptions.serviceName);
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            builder.ip(inetSocketAddress.getAddress()).port(inetSocketAddress.getPort());
            this.tracingOptions.customizeEndpoint(builder);
            return new BraveEndpoint(builder.build());
        }
        this.tracingOptions.customizeEndpoint(builder);
        return new BraveEndpoint(builder.build());
    }

    static class BraveTracingOptions {
        private final String serviceName;
        private final Consumer<Endpoint.Builder> endpointCustomizer;
        private final BiConsumer<RedisCommand<Object, Object, Object>, Span> spanCustomizer;

        BraveTracingOptions(String serviceName, Consumer<Endpoint.Builder> endpointCustomizer, BiConsumer<RedisCommand<Object, Object, Object>, Span> spanCustomizer) {
            this.serviceName = serviceName;
            this.endpointCustomizer = endpointCustomizer;
            this.spanCustomizer = spanCustomizer;
        }

        void customizeEndpoint(Endpoint.Builder builder) {
            this.endpointCustomizer.accept(builder);
        }

        void customizeSpan(RedisCommand<?, ?, ?> command, Span span) {
            this.spanCustomizer.accept(command, span);
        }
    }

    static enum BraveTraceContextProvider implements TraceContextProvider
    {
        INSTANCE;


        @Override
        public TraceContext getTraceContext() {
            Span span;
            brave.Tracer tracer = brave.Tracing.currentTracer();
            if (tracer != null && (span = tracer.currentSpan()) != null) {
                return new BraveTraceContext(span.context());
            }
            return null;
        }

        @Override
        public Mono<TraceContext> getTraceContextLater() {
            return Mono.deferContextual(Mono::justOrEmpty).filter(it -> it.hasKey(Span.class) || it.hasKey(brave.propagation.TraceContext.class)).map(it -> {
                if (it.hasKey(Span.class)) {
                    return new BraveTraceContext(((Span)it.get(Span.class)).context());
                }
                return new BraveTraceContext((brave.propagation.TraceContext)it.get(brave.propagation.TraceContext.class));
            });
        }
    }

    public static class BraveTraceContext
    implements TraceContext {
        final brave.propagation.TraceContext traceContext;

        private BraveTraceContext(brave.propagation.TraceContext traceContext) {
            this.traceContext = traceContext;
        }

        public static BraveTraceContext create(brave.propagation.TraceContext traceContext) {
            return new BraveTraceContext(traceContext);
        }
    }

    public static class BraveEndpoint
    implements Tracing.Endpoint {
        final Endpoint endpoint;

        public BraveEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
        }
    }

    static class BraveSpan
    extends Tracer.Span {
        private final Span span;
        private final BraveTracingOptions tracingOptions;
        private final boolean includeCommandArgsInSpanTags;

        BraveSpan(Span span, BraveTracingOptions tracingOptions, boolean includeCommandArgsInSpanTags) {
            this.span = span;
            this.tracingOptions = tracingOptions;
            this.includeCommandArgsInSpanTags = includeCommandArgsInSpanTags;
        }

        @Override
        public BraveSpan start(RedisCommand<?, ?, ?> command) {
            this.span.name(command.getType().name());
            if (this.includeCommandArgsInSpanTags && command.getArgs() != null) {
                this.span.tag("redis.args", command.getArgs().toCommandString());
            }
            if (!(command instanceof CompleteableCommand)) {
                throw new IllegalArgumentException("Command " + command + " must implement CompleteableCommand to attach Span completion to command completion");
            }
            CompleteableCommand completeableCommand = (CompleteableCommand)((Object)command);
            completeableCommand.onComplete((o, throwable) -> {
                if (command.getOutput() != null) {
                    String error = command.getOutput().getError();
                    if (error != null) {
                        this.span.tag("error", error);
                    } else if (throwable != null) {
                        this.span.tag("exception", throwable.toString());
                        this.span.error(throwable);
                    }
                }
                this.span.finish();
            });
            this.span.start();
            this.tracingOptions.customizeSpan(command, this.span);
            return this;
        }

        @Override
        public BraveSpan name(String name) {
            this.span.name(name);
            return this;
        }

        @Override
        public BraveSpan annotate(String value) {
            this.span.annotate(value);
            return this;
        }

        @Override
        public BraveSpan tag(String key, String value) {
            this.span.tag(key, value);
            return this;
        }

        @Override
        public BraveSpan error(Throwable throwable) {
            this.span.error(throwable);
            return this;
        }

        @Override
        public BraveSpan remoteEndpoint(Tracing.Endpoint endpoint) {
            Endpoint zkEndpoint = ((BraveEndpoint)BraveEndpoint.class.cast((Object)endpoint)).endpoint;
            if (zkEndpoint.serviceName() != null) {
                this.span.remoteServiceName(zkEndpoint.serviceName());
            }
            String ip = zkEndpoint.ipv6() != null ? zkEndpoint.ipv6() : zkEndpoint.ipv4();
            this.span.remoteIpAndPort(ip, zkEndpoint.portAsInt());
            return this;
        }

        @Override
        public void finish() {
            this.span.finish();
        }

        public Span getSpan() {
            return this.span;
        }
    }

    static class BraveTracer
    extends Tracer {
        private final brave.Tracing tracing;
        private final BraveTracingOptions tracingOptions;
        private final boolean includeCommandArgsInSpanTags;

        BraveTracer(brave.Tracing tracing, BraveTracingOptions tracingOptions, boolean includeCommandArgsInSpanTags) {
            this.tracing = tracing;
            this.tracingOptions = tracingOptions;
            this.includeCommandArgsInSpanTags = includeCommandArgsInSpanTags;
        }

        @Override
        public Tracer.Span nextSpan() {
            return this.postProcessSpan(this.tracing.tracer().nextSpan());
        }

        @Override
        public Tracer.Span nextSpan(TraceContext traceContext) {
            if (!(traceContext instanceof BraveTraceContext)) {
                return this.nextSpan();
            }
            BraveTraceContext braveTraceContext = (BraveTraceContext)BraveTraceContext.class.cast(traceContext);
            if (braveTraceContext.traceContext == null) {
                return this.nextSpan();
            }
            return this.postProcessSpan(this.tracing.tracer().nextSpan(TraceContextOrSamplingFlags.create((brave.propagation.TraceContext)braveTraceContext.traceContext)));
        }

        private Tracer.Span postProcessSpan(Span span) {
            if (span == null || span.isNoop()) {
                return NoOpTracing.NoOpSpan.INSTANCE;
            }
            return new BraveSpan(span.kind(Span.Kind.CLIENT), this.tracingOptions, this.includeCommandArgsInSpanTags);
        }
    }

    public static class Builder {
        private brave.Tracing tracing;
        private String serviceName = "redis";
        private Consumer<Endpoint.Builder> endpointCustomizer = it -> {};
        private BiConsumer<RedisCommand<Object, Object, Object>, Span> spanCustomizer = (command, span) -> {};
        private boolean includeCommandArgsInSpanTags = true;

        private Builder() {
        }

        public Builder tracing(brave.Tracing tracing) {
            LettuceAssert.notNull((Object)tracing, "Tracing must not be null!");
            this.tracing = tracing;
            return this;
        }

        public Builder serviceName(String serviceName) {
            LettuceAssert.notEmpty((CharSequence)serviceName, "Service name must not be null!");
            this.serviceName = serviceName;
            return this;
        }

        public Builder excludeCommandArgsFromSpanTags() {
            return this.includeCommandArgsInSpanTags(false);
        }

        public Builder includeCommandArgsInSpanTags(boolean includeCommandArgsInSpanTags) {
            this.includeCommandArgsInSpanTags = includeCommandArgsInSpanTags;
            return this;
        }

        public Builder endpointCustomizer(Consumer<Endpoint.Builder> endpointCustomizer) {
            LettuceAssert.notNull(endpointCustomizer, "Endpoint customizer must not be null!");
            this.endpointCustomizer = endpointCustomizer;
            return this;
        }

        public Builder spanCustomizer(Consumer<Span> spanCustomizer) {
            LettuceAssert.notNull(spanCustomizer, "Span customizer must not be null!");
            this.spanCustomizer = (command, span) -> spanCustomizer.accept((Span)span);
            return this;
        }

        public Builder spanCustomizer(BiConsumer<RedisCommand<Object, Object, Object>, Span> spanCustomizer) {
            LettuceAssert.notNull(spanCustomizer, "Span customizer must not be null!");
            this.spanCustomizer = spanCustomizer;
            return this;
        }

        public BraveTracing build() {
            LettuceAssert.notNull((Object)this.tracing, "Brave Tracing must not be null!");
            return new BraveTracing(this);
        }
    }
}

