/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.async;

import io.opentracing.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.ReflectionUtils;

class ExecutorMethodInterceptor<T extends Executor>
implements MethodInterceptor {
    private final T delegate;
    private final Tracer tracer;
    private final BiFunction<T, Tracer, T> tracedExecutorProvider;

    ExecutorMethodInterceptor(T delegate, BiFunction<T, Tracer, T> tracedExecutorProvider, Tracer tracer) {
        this.delegate = delegate;
        this.tracedExecutorProvider = tracedExecutorProvider;
        this.tracer = tracer;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Executor tracedExecutor = (Executor)this.tracedExecutorProvider.apply(this.delegate, this.tracer);
        Method methodOnTracedBean = this.getMethod(invocation, tracedExecutor);
        if (methodOnTracedBean != null) {
            try {
                return methodOnTracedBean.invoke((Object)tracedExecutor, invocation.getArguments());
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }
        return invocation.proceed();
    }

    private Method getMethod(MethodInvocation invocation, Object object) {
        Method method = invocation.getMethod();
        return ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
    }
}

