/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class SpanLogsAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private final Tracer tracer;

    public SpanLogsAppender(Tracer tracer) {
        this.name = SpanLogsAppender.class.getSimpleName();
        this.tracer = tracer;
    }

    protected void append(ILoggingEvent event) {
        Span span = this.tracer.activeSpan();
        if (span != null) {
            Throwable throwable;
            IThrowableProxy throwableProxy;
            HashMap<String, Object> logs = new HashMap<String, Object>(6);
            logs.put("logger", event.getLoggerName());
            logs.put("level", event.getLevel().toString());
            logs.put("thread", event.getThreadName());
            logs.put("message", event.getFormattedMessage());
            if (Level.ERROR.equals(event.getLevel())) {
                logs.put("event", Tags.ERROR);
            }
            if ((throwableProxy = event.getThrowableProxy()) instanceof ThrowableProxy && (throwable = ((ThrowableProxy)throwableProxy).getThrowable()) != null) {
                logs.put("error.object", throwable);
            }
            span.log(TimeUnit.MICROSECONDS.convert(event.getTimeStamp(), TimeUnit.MILLISECONDS), logs);
        }
    }
}

